--
-- Table structure for table `T_ARMS_POC`
--
CREATE TABLE IF NOT EXISTS `aRMS`.`T_ARMS_POC_LOG` (

    `c_id`                                  bigint(20) NOT NULL COMMENT '노드 아이디',
    `c_parentid`                            bigint(20) NOT NULL COMMENT '부모 노드 아이디',
    `c_position`                            bigint(20) NOT NULL COMMENT '노드 포지션',
    `c_left`                                bigint(20) NOT NULL COMMENT '노드 좌측 끝 포인트',
    `c_right`                               bigint(20) NOT NULL COMMENT '노드 우측 끝 포인트',
    `c_level`                               bigint(20) NOT NULL COMMENT '노드 DEPTH',
    `c_title`                               VARCHAR(255) COMMENT '노드 명',
    `c_type`                                VARCHAR(255) COMMENT '노드 타입',

    `c_method`                              text NULL COMMENT '노드 변경 행위',
    `c_state`                               text NULL COMMENT '노드 상태값 ( 이전인지. 이후인지)',
    `c_date`                                DATETIME NULL COMMENT '노드 변경 시',

    `c_poc_first_name`                      VARCHAR(255) COMMENT '신청자 이름',
    `c_poc_last_name`                       VARCHAR(255) COMMENT '신청자 성',
    `c_poc_full_name`                       VARCHAR(255) COMMENT '신청자 성명',
    `c_poc_company_name`                    VARCHAR(255) COMMENT '회사명',
    `c_poc_company_size`                    VARCHAR(255) COMMENT '회사규모',
    `c_poc_job_title`                       VARCHAR(255) COMMENT '직함',
    `c_poc_job_position`                    VARCHAR(255) COMMENT '직급',
    `c_poc_email_address`                   VARCHAR(255) COMMENT '메일',

    `c_poc_country`                     	VARCHAR(255) COMMENT '국가',
    `c_poc_country_code`                    bigint(20) COMMENT '국가코드',
    `c_poc_contact_number`                  VARCHAR(255) COMMENT '연락처',

    `c_poc_inquiry_content`               	text COMMENT '문의 내용',
    `c_poc_inquiry_date`                    DATETIME NULL COMMENT '문의 날짜',

    `c_poc_assignee_id`                     VARCHAR(255) COMMENT '처리 담당자 아이디',
    `c_poc_status`                     	 	VARCHAR(255) COMMENT '처리 상태',
    `c_poc_status_memo`                     text COMMENT '처리 메모',
    `c_poc_status_updated`                  DATETIME NULL COMMENT '처리 상태 업데이트일',
    `c_poc_marketing_consent`				TINYINT(1) COMMENT '마케팅 동의여부',

    `c_poc_etc`                 			VARCHAR(255)    COMMENT '비고',
    `c_poc_desc`                			text            COMMENT '설명',
    `c_poc_contents`            			longtext        COMMENT '내용'

    ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='PoC 테이블 로그';


CREATE TABLE IF NOT EXISTS `aRMS`.`T_ARMS_POC` (

    `c_id`                                   bigint(20) AUTO_INCREMENT primary key COMMENT '노드 아이디',
    `c_parentid`                             bigint(20) NOT NULL COMMENT '부모 노드 아이디',
    `c_position`                             bigint(20) NOT NULL COMMENT '노드 포지션',
    `c_left`                                 bigint(20) NOT NULL COMMENT '노드 좌측 끝 포인트',
    `c_right`                                bigint(20) NOT NULL COMMENT '노드 우측 끝 포인트',
    `c_level`                                bigint(20) NOT NULL COMMENT '노드 DEPTH',
    `c_title`                                VARCHAR(255) COMMENT '노드 명',
    `c_type`                                 VARCHAR(255) COMMENT '노드 타입',

    `c_poc_first_name`                       VARCHAR(255) COMMENT '신청자 이름',
    `c_poc_last_name`                        VARCHAR(255) COMMENT '신청자 성',
    `c_poc_full_name`                        VARCHAR(255) COMMENT '신청자 성명',
    `c_poc_company_name`                     VARCHAR(255) COMMENT '회사명',
    `c_poc_company_size`                     VARCHAR(255) COMMENT '회사규모',
    `c_poc_job_title`                        VARCHAR(255) COMMENT '직함',
    `c_poc_job_position`                     VARCHAR(255) COMMENT '직급',
    `c_poc_email_address`                    VARCHAR(255) COMMENT '메일',

    `c_poc_country`                     	 VARCHAR(255) COMMENT '국가',
    `c_poc_country_code`                     bigint(20) COMMENT '국가코드',
    `c_poc_contact_number`                   VARCHAR(255) COMMENT '연락처',

    `c_poc_inquiry_content`               	 text COMMENT '문의 내용',
    `c_poc_inquiry_date`                     DATETIME NULL COMMENT '문의 날짜',

    `c_poc_status`                     	 	 VARCHAR(255) COMMENT '처리 상태',
    `c_poc_status_memo`                      text COMMENT '처리 메모',
    `c_poc_status_updated`                   DATETIME NULL COMMENT '처리 상태 업데이트일',
    `c_poc_marketing_consent`				TINYINT(1) COMMENT '마케팅 동의여부',

    `c_poc_etc`                 			varchar(255)    COMMENT '비고',
    `c_poc_desc`                			text            COMMENT '설명',
    `c_poc_contents`            			longtext        COMMENT '내용'

    ) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='PoC 테이블';

DELIMITER $$
CREATE TRIGGER TG_INSERT_T_ARMS_POC
    BEFORE  INSERT ON T_ARMS_POC
    FOR EACH ROW
BEGIN
    insert into T_ARMS_POC_LOG (C_ID, C_PARENTID, C_POSITION, C_LEFT, C_RIGHT, C_LEVEL, C_TITLE, C_TYPE, C_METHOD, C_STATE, C_DATE)
    values (NEW.C_ID,NEW.C_PARENTID,NEW.C_POSITION,NEW.C_LEFT,NEW.C_RIGHT,NEW.C_LEVEL,NEW.C_TITLE,NEW.C_TYPE,'update','변경이전데이터',now());
END $$
DELIMITER ;

DELIMITER $$
CREATE TRIGGER TG_UPDATE_T_ARMS_POC
    BEFORE  UPDATE ON T_ARMS_POC
    FOR EACH ROW
BEGIN
    insert into T_ARMS_POC_LOG (C_ID, C_PARENTID, C_POSITION, C_LEFT, C_RIGHT, C_LEVEL, C_TITLE, C_TYPE, C_METHOD, C_STATE, C_DATE)
    values (OLD.C_ID,OLD.C_PARENTID,OLD.C_POSITION,OLD.C_LEFT,OLD.C_RIGHT,OLD.C_LEVEL,OLD.C_TITLE,OLD.C_TYPE,'update','변경이전데이터',now());

    insert into T_ARMS_POC_LOG (C_ID, C_PARENTID, C_POSITION, C_LEFT, C_RIGHT, C_LEVEL, C_TITLE, C_TYPE, C_METHOD, C_STATE, C_DATE)
    values (NEW.C_ID,NEW.C_PARENTID,NEW.C_POSITION,NEW.C_LEFT,NEW.C_RIGHT,NEW.C_LEVEL,NEW.C_TITLE,NEW.C_TYPE,'update','변경이후데이터',now());
END $$
DELIMITER ;

DELIMITER $$
CREATE TRIGGER TG_DELETE_T_ARMS_POC
    BEFORE  DELETE ON T_ARMS_POC
    FOR EACH ROW
BEGIN
    insert into T_ARMS_POC_LOG (C_ID, C_PARENTID, C_POSITION, C_LEFT, C_RIGHT, C_LEVEL, C_TITLE, C_TYPE, C_METHOD, C_STATE, C_DATE)
    values (OLD.C_ID,OLD.C_PARENTID,OLD.C_POSITION,OLD.C_LEFT,OLD.C_RIGHT,OLD.C_LEVEL,OLD.C_TITLE,OLD.C_TYPE,'delete','삭제된데이터',now());
END $$
DELIMITER ;

Insert into `aRMS`.`T_ARMS_POC` (C_ID, C_PARENTID, C_POSITION, C_LEFT, C_RIGHT, C_LEVEL, C_TITLE, C_TYPE)
Values (1, 0, 0, 1, 4, 0, 'T_ARMS_POC', 'root');
Insert into `aRMS`.`T_ARMS_POC` (C_ID, C_PARENTID, C_POSITION, C_LEFT, C_RIGHT, C_LEVEL, C_TITLE, C_TYPE)
Values (2, 1, 0, 2, 3, 1, 'PoC 신청', 'drive');