package com.arms.api.analysis.cost.service;

import com.arms.api.analysis.cost.model.dto.CalculationCostDTO;
import com.arms.api.analysis.cost.model.dto.CostDTO;
import com.arms.api.analysis.cost.model.vo.*;

import java.util.List;
import java.util.Set;

public interface CostService {

    AllAssigneeVO getAssigneeList(CostDTO costDTO) throws Exception;

    RequirementDifficultyAndPriorityVO getRequirementListStats(CostDTO costDTO) throws Exception;

    LinkedJiraIssueVO getLinkedJiraIssuesByVersionAndRequirement(CostDTO costDTO) throws Exception;

    ProductCostResponseVO candleStickChartAPI(CostDTO costDTO) throws Exception;

    Set<String> getAssignees(Long pdServiceLink, List<Long> pdServiceVersionLinks);

    List<AssigneeTimeDiffVO> getEstimatedPeriodCostByAccountId(CostDTO costDTO) throws Exception;

    CostCalculationVO calculateCostAll(CostDTO costDTO) throws Exception;

    CostCalculationVO calculateVersionCost(CostDTO costDTO) throws Exception;

    CostCalculationVO calculateRequirementCost(CostDTO costDTO) throws Exception;

    CostCalculationVO calculateAssigneeCost(CostDTO costDTO) throws Exception;

    CostCalculationVO toBeCalculateCost(CalculationCostDTO calculationCostDTO) throws Exception;

}
