package com.arms.api.backoffice.config.esindex.controller;

import com.arms.api.backoffice.config.esindex.model.vo.IndexStatusSumVO;
import com.arms.api.backoffice.config.esindex.model.vo.IndexStatusesWithJobIdVO;
import com.arms.egovframework.javaservice.treeframework.controller.CommonResponse;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.arms.api.backoffice.config.esindex.service.EsIndexConfigService;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;

import java.util.List;

@Slf4j
@RestController
@RequestMapping("/arms/backoffice/es-index")
@AllArgsConstructor
public class EsIndexConfigController {

	private final EsIndexConfigService esIndexConfigService;

	@GetMapping("/sum-list")
	public ResponseEntity<CommonResponse.ApiResult<List<IndexStatusSumVO>>> esIndexSumList() {
		return esIndexConfigService.esIndexSumList();
	}

	@GetMapping("/index-status/histories")
	public ResponseEntity<CommonResponse.ApiResult<List<IndexStatusesWithJobIdVO>>> indexJobHistories() {
		return esIndexConfigService.indexJobHistories();
	}

}
