package com.arms.api.patchnote.service;

import com.arms.api.patchnote.model.PatchnoteDTO;
import com.arms.api.patchnote.model.PatchnoteEntity;
import com.arms.egovframework.javaservice.treeframework.TreeConstant;
import com.arms.egovframework.javaservice.treeframework.service.TreeServiceImpl;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.modelmapper.ModelMapper;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;

@Slf4j
@RequiredArgsConstructor
@Service("patchnoteService")
public class PatchnoteServiceImpl extends TreeServiceImpl implements PatchnoteService {

    private final ModelMapper modelMapper;

    @Override
    @Transactional
    public PatchnoteEntity addPatchnote(PatchnoteDTO patchnoteDTO) throws Exception {
        log.info("[ PatchnoteService :: addPatchnote ] {}", patchnoteDTO);
        PatchnoteEntity patchnoteEntity = modelMapper.map(patchnoteDTO, PatchnoteEntity.class);
        patchnoteEntity.setRef(TreeConstant.First_Node_CID);
        patchnoteEntity.setC_type(TreeConstant.Leaf_Node_TYPE);
        patchnoteEntity.setC_patchnote_created(new Date());

        return this.addNode(patchnoteEntity);
    }


    @Transactional
    public PatchnoteEntity updatePatchnote(PatchnoteDTO patchnoteDTO) throws Exception {
        log.info("[ PatchnoteService :: updatePatchnote ] {}", patchnoteDTO);
        PatchnoteEntity patchnoteEntity = modelMapper.map(patchnoteDTO, PatchnoteEntity.class);
        patchnoteEntity.setC_patchnote_updated(new Date());
        this.updateNode(patchnoteEntity);

        return patchnoteEntity;
    }
}