package com.arms.api.requirement.reqadd_state_pure.controller;

import com.arms.api.requirement.reqadd_state_pure.model.ReportReqAddEntity;
import com.arms.api.requirement.reqadd_state_pure.model.ReqAddStatePureDTO;
import com.arms.api.requirement.reqadd_state_pure.model.ReqAddStatePureEntity;
import com.arms.api.requirement.reqadd_state_pure.model.vo.ProgressResultVO;
import com.arms.api.requirement.reqadd_state_pure.model.vo.ReportReqAddVO;
import com.arms.api.requirement.reqadd_state_pure.model.vo.WeeklyReportReqAddVO;
import com.arms.api.requirement.reqadd_state_pure.service.ReqAddStatePure;
import com.arms.egovframework.javaservice.treeframework.controller.TreeAbstractController;
import com.arms.egovframework.javaservice.treeframework.util.StringUtils;
import lombok.extern.slf4j.Slf4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import javax.annotation.PostConstruct;
import java.util.List;

@Slf4j
@Controller
@RequestMapping(value = {"/arms/reqAddStatePure"})
public class ReqAddStatePureController extends TreeAbstractController<ReqAddStatePure, ReqAddStatePureDTO, ReqAddStatePureEntity> {

    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    @Qualifier("reqAddStatePure")
    private ReqAddStatePure reqAddStatePure;

    @PostConstruct
    public void initialize() {
        setTreeService(reqAddStatePure);
        setTreeEntity(ReqAddStatePureEntity.class);
    }

    @ResponseBody
    @RequestMapping(
            value = {"/{changeReqTableName}/reqProgress.do"},
            method = {RequestMethod.GET}
    )
    public ModelAndView reqProgress(@PathVariable(value ="changeReqTableName") String changeReqTableName,
                                    ReqAddStatePureDTO reqAddStatePureDTO, ModelMap model) throws Exception {

        log.info("ReqAddPureController :: reqProgress");
        Long pdServiceId = Long.parseLong(StringUtils.replace(changeReqTableName, "T_ARMS_REQADD_", ""));

        ReqAddStatePureEntity reqAddStatePureEntity = modelMapper.map(reqAddStatePureDTO, ReqAddStatePureEntity.class);
        List<ReqAddStatePureEntity> list = reqAddStatePure.reqProgress(reqAddStatePureEntity, changeReqTableName,
                                                                        pdServiceId, reqAddStatePureEntity.getC_req_pdservice_versionset_link());

        ModelAndView modelAndView = new ModelAndView("jsonView");
        modelAndView.addObject("result", list);

        return modelAndView;
    }

    @ResponseBody
    @RequestMapping(
            value = {"/{changeReqTableName}/calculateProgress.do"},
            method = {RequestMethod.GET}
    )
    public ResponseEntity<?> calculateProgress(@PathVariable(value ="changeReqTableName") String changeReqTableName,
                                               ReqAddStatePureDTO reqAddStatePureDTO) throws Exception {

        log.info("ReqAddPureController :: calculateProgress");
        Long pdServiceId = Long.parseLong(StringUtils.replace(changeReqTableName, "T_ARMS_REQADD_", ""));

        ReqAddStatePureEntity reqAddStatePureEntity = modelMapper.map(reqAddStatePureDTO, ReqAddStatePureEntity.class);
        ProgressResultVO resultVO = reqAddStatePure.calculateProgress(reqAddStatePureEntity, changeReqTableName,
                                                        pdServiceId, reqAddStatePureEntity.getC_req_pdservice_versionset_link());

        return ResponseEntity.ok(resultVO);
    }

    @ResponseBody
    @RequestMapping(
            value = {"/{changeReqTableName}/reportReqStatus"},
            method = {RequestMethod.GET}
    )
    public ResponseEntity<?> reportReqStatus(@PathVariable(value ="changeReqTableName") String changeReqTableName,
                                               ReqAddStatePureDTO reqAddStatePureDTO) throws Exception {

        log.info("ReqAddPureController :: reportReqStatus");
        Long pdServiceId = Long.parseLong(StringUtils.replace(changeReqTableName, "T_ARMS_REQADD_", ""));

        ReportReqAddEntity reportReqAddEntity = modelMapper.map(reqAddStatePureDTO, ReportReqAddEntity.class);
        List<ReportReqAddVO> list = reqAddStatePure.reportReqStatus(reportReqAddEntity, changeReqTableName,
                pdServiceId, reportReqAddEntity.getC_req_pdservice_versionset_link());

        return ResponseEntity.ok(list);
    }

    @ResponseBody
    @RequestMapping(
            value = {"/{changeReqTableName}/weeklyReportReqStatus"},
            method = {RequestMethod.GET}
    )
    public ResponseEntity<?> weeklyReportReqStatus(@PathVariable(value ="changeReqTableName") String changeReqTableName,
                                             ReqAddStatePureDTO reqAddStatePureDTO) throws Exception {

        log.info("ReqAddPureController :: weeklyReportReqStatus");
        Long pdServiceId = Long.parseLong(StringUtils.replace(changeReqTableName, "T_ARMS_REQADD_", ""));

        ReqAddStatePureEntity reqAddStatePureEntity = modelMapper.map(reqAddStatePureDTO, ReqAddStatePureEntity.class);
        List<WeeklyReportReqAddVO> result = reqAddStatePure.weeklyReportReqStatus(reqAddStatePureEntity, changeReqTableName,
                pdServiceId, reqAddStatePureEntity.getC_req_pdservice_versionset_link());

        return ResponseEntity.ok(result);
    }
}