/*
 * @author Dongmin.lee
 * @since 2023-10-22
 * @version 23.10.22
 * @see <pre>
 *  Copyright (C) 2007 by 313 DEV GRP, Inc - All Rights Reserved
 *  Unauthorized copying of this file, via any medium is strictly prohibited
 *  Proprietary and confidential
 *  Written by 313 developer group <313@313.co.kr>, December 2010
 * </pre>
 */
package com.arms.api.requirement.reqstate_category.service;

import com.arms.api.requirement.reqstate_category.model.ReqStateCategoryEntity;
import com.arms.api.util.communicate.external.MiddleProxyService;
import com.arms.api.util.communicate.external.request.redis.ArmsStateCategoryDTO;
import com.arms.egovframework.javaservice.treeframework.service.TreeServiceImpl;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;


@Slf4j
@RequiredArgsConstructor
@Service("reqStateCategory")
public class ReqStateCategoryImpl extends TreeServiceImpl implements ReqStateCategory {

    private final MiddleProxyService middleProxyService;

    @Override
    public void cacheArmsStateCategoryData() throws Exception {
        List<ReqStateCategoryEntity> reqStateCategoryEntityList = this.getNodesWithoutRoot(new ReqStateCategoryEntity());

        List<ArmsStateCategoryDTO> armsStateCategoryDTOs = reqStateCategoryEntityList.stream()
                .filter(Objects::nonNull)
                .map(reqStateCategoryEntity -> ArmsStateCategoryDTO.builder()
                        .id(String.valueOf(reqStateCategoryEntity.getC_id()))
                        .name(reqStateCategoryEntity.getC_title())
                        .build())
                .collect(Collectors.toList());

        middleProxyService.setArmsStateCategory(armsStateCategoryDTOs);
    }
}