/*
 * @author Dongmin.lee
 * @since 2023-03-20
 * @version 23.03.20
 * @see <pre>
 *  Copyright (C) 2007 by 313 DEV GRP, Inc - All Rights Reserved
 *  Unauthorized copying of this file, via any medium is strictly prohibited
 *  Proprietary and confidential
 *  Written by 313 developer group <313@313.co.kr>, December 2010
 * </pre>
 */
package com.arms.api.util.dynamicscheduler.service;

import com.arms.api.util.dynamicscheduler.model.SchedulerType;
import com.arms.egovframework.javaservice.treeframework.service.TreeService;

public interface SchedulerService extends TreeService {

    void discoverByFullDateRange(SchedulerType schedulerEnum) throws Exception;

    void discoverByDateRange(SchedulerType schedulerEnum, String startDate, String endDate) throws Exception;

    void discoverByPreviousDay(SchedulerType schedulerEnum) throws Exception;

    void updateReqStatusFromElasticsearch(SchedulerType schedulerEnum) throws Exception;

    void retryFailedReqStatusCreationToElasticsearch(SchedulerType schedulerEnum) throws Exception;

    String cacheStatusMappingData() throws Exception;

}