package com.arms.api.wiki.model;

import com.arms.api.util.aspect.MailContent;
import com.arms.api.util.aspect.MailSubject;
import com.arms.egovframework.javaservice.treeframework.model.TreeBaseDTO;
import lombok.*;

import java.time.LocalDateTime;

@Getter
@Setter
@Builder
@ToString(callSuper=true)
@NoArgsConstructor
@AllArgsConstructor
public class WikiDTO extends TreeBaseDTO {

    @MailSubject
    @MailContent
    private String c_wiki_title;

    private LocalDateTime c_wiki_create_date;

    private LocalDateTime c_wiki_update_date;

    private String c_wiki_etc;

    private String c_wiki_desc;

    private String c_wiki_contents;
}
