package com.arms.api.analysis.cost.model.dto;

import com.arms.api.util.model.dto.PdServiceAndIsReqDTO;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.util.List;

@Getter
@Setter
@AllArgsConstructor
@NoArgsConstructor
public class CostDTO {

    private PdServiceAndIsReqDTO pdServiceAndIsReq;
    private String startDate;
    private String endDate;

    public CostDTO(PdServiceAndIsReqDTO pdServiceAndIsReq) {
        this.pdServiceAndIsReq = pdServiceAndIsReq;
    }

    public Long pdServiceLink() {
        return pdServiceAndIsReq.getPdServiceLink();
    }

    public List<Long> pdServiceVersionLinks() {
        return pdServiceAndIsReq.getPdServiceVersionLinks();
    }

    public Boolean isReq() {
        return pdServiceAndIsReq.getIsReq();
    }

    public static CostDTO of(PdServiceAndIsReqDTO pdServiceAndIsReq) {
        return new CostDTO(pdServiceAndIsReq);
    }
}
