package com.arms.api.analysis.resource.model.vo;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;
import lombok.NoArgsConstructor;

import java.util.List;

@Getter
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class StackedHorizontalBarChartVO {

    @JsonProperty("yaxisVO")
    StackedHorizontalBarChartYAxisVO yAxisVO;

    @JsonProperty("series")
    List<StackedHorizontalBarSeriesVO> series;

    @Getter
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class StackedHorizontalBarChartYAxisVO {
        String type;
        List<String> data;
    }

    @Getter
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class StackedHorizontalBarSeriesVO {

        String name;
        String type;
        List<Long> data;
    }
}
