package com.arms.api.analysis.resource.model.vo.treemap;

import com.arms.egovframework.javaservice.treeframework.excel.ExcelClassAnnotation;
import com.arms.egovframework.javaservice.treeframework.excel.ExcelFieldAnnotation;
import lombok.*;

@Getter
@Setter
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ExcelClassAnnotation(sheetName = "Sheet2", headerRowSize = 1, headerTitleName = "작업자별 요구사항이슈 관여도 데이터")
public class TreemapExcelVO {

    private String assigneeId;
    @ExcelFieldAnnotation(columnIndex = 0, headerName = "작업자 명")
    private String assigneeName;

    @ExcelFieldAnnotation(columnIndex = 1, headerName = "버전 정보")
    private String versionNameList;
    @ExcelFieldAnnotation(columnIndex = 2, headerName = "A-RMS 요구사항 이슈 키")
    private String reqKey; // parentReqKey
    @ExcelFieldAnnotation(columnIndex = 3, headerName = "A-RMS 요구사항 이슈")
    private String reqSummary;

    @ExcelFieldAnnotation(columnIndex = 4, headerName = "요구사항 담당자 여부")
    private String isReqAssignee;
    @ExcelFieldAnnotation(columnIndex = 5, formatting = "%d",headerName = "전체 연결이슈 수")
    private Long notReqIssueTotal;
    @ExcelFieldAnnotation(columnIndex = 6, formatting = "%d",headerName = "관여한 연결이슈 수")
    private Long contributionNotReqIssueCount;
    @ExcelFieldAnnotation(columnIndex = 7, headerName = "관여한 연결이슈 상태")
    private String notReqIssueStatusList;
    @ExcelFieldAnnotation(columnIndex = 8, formatting = "%.0f",headerName = "관여도(%)")
    private String contribution;
}
