package com.arms.api.analysis.resource.model.vo.wordcloud;

import com.arms.egovframework.javaservice.treeframework.excel.ExcelClassAnnotation;
import com.arms.egovframework.javaservice.treeframework.excel.ExcelFieldAnnotation;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;
import lombok.NoArgsConstructor;

@Getter
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ExcelClassAnnotation(sheetName = "Sheet2", headerRowSize = 1, headerTitleName = "작업자 ALM 이슈 데이터")
public class WordCloudExcelVO {

    private String accountId;
    @ExcelFieldAnnotation(columnIndex = 0, headerName = "작업자 명")
    private String name;

    // 담당하고 있는 issueTotal
    @ExcelFieldAnnotation(columnIndex = 1, formatting = "%d",headerName = "전체 이슈")
    private Long issueTotal;
    @ExcelFieldAnnotation(columnIndex = 2, formatting = "%d",headerName = "요구사항 이슈")
    private Long reqIssueTotal;
    @ExcelFieldAnnotation(columnIndex = 3, formatting = "%d",headerName = "연결 이슈")
    private Long notReqIssueTotal;
}
