package com.arms.api.analysis.resource.service;

import com.arms.api.analysis.resource.model.dto.ResourceDTO;
import com.arms.api.analysis.resource.model.dto.ResourceSubgroupDTO;
import com.arms.api.analysis.resource.model.dto.ResourceWithAssigneesSubGroupDTO;
import com.arms.api.analysis.resource.model.dto.ResourceWithVersionIdNamesDTO;
import com.arms.api.analysis.resource.model.vo.StackedHorizontalBarChartVO;
import com.arms.api.analysis.resource.model.vo.UniqueAssigneeIssueStatusVO;
import com.arms.api.analysis.resource.model.vo.UniqueAssigneeVO;
import com.arms.api.analysis.resource.model.vo.WordCloudVO;
import com.arms.api.analysis.resource.model.vo.horizontalbar.HorizontalBarChartYAxisAndSeriesVO;
import com.arms.api.analysis.resource.model.vo.horizontalbar.ReqAndNotReqHorizontalBarChartVO;
import com.arms.api.analysis.resource.model.vo.pie.ReqAndNotReqPieChartVO;
import com.arms.api.analysis.resource.model.vo.pie.TotalIssueAndPieChartVO;
import com.arms.api.analysis.resource.model.vo.treemap.TreeMapWorkerVO;
import com.arms.api.analysis.resource.model.vo.treemap.TreemapExcelVO;
import com.arms.api.dashboard.model.SankeyData;

import java.util.List;

public interface ResourceService {
    // issue-status (datatable)
    List<UniqueAssigneeIssueStatusVO> issueStatusDataByAssignee(ResourceDTO resourceDTO);

    // sankey
    SankeyData sankeyChartAPIWithTopN(ResourceDTO resourceDTO, Integer topN) throws Exception;
    // treemap
    List<TreeMapWorkerVO> findTreeMapChartDataV3(ResourceWithVersionIdNamesDTO resourceWithVersionIdNamesDTO) throws Exception;
    List<TreemapExcelVO> assigneeRequirementInvolvementDetailData(ResourceWithVersionIdNamesDTO resourceWithVersionIdNamesDTO) throws Exception;

    List<UniqueAssigneeVO> findAssigneesInfoData(ResourceDTO resourceDTO) throws Exception;
    // word-cloud
    List<WordCloudVO> findWordCloudData(ResourceDTO resourceDTO);
    // statcked-horizontal-bar
    StackedHorizontalBarChartVO issueStatusStackedBarChartData(ResourceDTO resourceDTO);

    // 파이차트
    ReqAndNotReqPieChartVO findPieChartData(ResourceDTO resourceDTO);
    // 파이차트(expand)
    TotalIssueAndPieChartVO findPieChartDataExpand(ResourceDTO resourceDTO);

    // 수평바 - 파이차트 이후, accounts 와 isReq로 조회
    List<HorizontalBarChartYAxisAndSeriesVO> findHorizontalBarChartData(ResourceDTO resourceDTO);
    // 수평바 - (n and nr at once by same accounts)
    ReqAndNotReqHorizontalBarChartVO findHorizontalBarChartDataBySameAccounts(ResourceDTO resourceDTO);

}
