package com.arms.api.analysis.time.service;

import com.arms.api.analysis.time.model.RidgeLineVO;
import com.arms.api.analysis.time.model.dto.TimeDTO;
import com.arms.api.analysis.time.model.vo.AlmIssueStatVO;
import com.arms.api.analysis.time.model.vo.AlmIssuesByVersionVO;
import com.arms.api.analysis.time.model.vo.HeatMapVO;
import com.arms.api.analysis.time.model.vo.ScatterChartVO;

import java.util.List;

public interface TimeService {

    // 스캐터
    List<ScatterChartVO> getScatterChartData(TimeDTO timeDTO);
    // 히트맵
    HeatMapVO getHeatMapDataByUpdated(TimeDTO timeDTO);
    // 멀티콤비네이션
    List<AlmIssueStatVO> getMultiCombinationChartData(TimeDTO timeDTO);
    // vertical-timeline
    List<AlmIssuesByVersionVO> getUpdatedPdServiceVersionAlmIssueByDate(TimeDTO timeDTO);
    // ridge-line
    List<RidgeLineVO> getRidgeLineData(TimeDTO timeDTO);
}

