package com.arms.api.analysis.topmenu.model.vo;

import com.arms.api.analysis.topmenu.model.CategoryStatus;
import com.arms.api.requirement.reqadd.model.entity.ReqAddEntity;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import static com.arms.api.analysis.topmenu.model.CategoryStatus.*;

@AllArgsConstructor
@Builder
@Getter
public class ReqStatusCountVO {

	private final Long openCount;

	private final Long inProgressCount;

	private final Long resolvedCount;

	private final Long closedCount;

	private final Long etcCount;

	private final Long nullCount;

	private final Long folderCount;

	private final Long totalCount;


	public ReqStatusCountVO(List<ReqAddEntity> list){

		Map<CategoryStatus, Long> map = list.stream()
			.collect(Collectors.groupingBy(
				entity -> entity.카테고리_상태(),
				Collectors.counting()
			));

		this.openCount = map.getOrDefault(OPEN,0L);

		this.inProgressCount = map.getOrDefault(IN_PROGRESS,0L);

		this.resolvedCount = map.getOrDefault(RESOLVED,0L);

		this.closedCount = map.getOrDefault(CLOSED,0L);

		this.etcCount = map.getOrDefault(ETC,0L);

		this.nullCount = map.getOrDefault(NULL,0L);

		this.folderCount = map.getOrDefault(FOLDER,0L);

		this.totalCount = list.size() - map.getOrDefault(FOLDER,0L);

	}



}
