package com.arms.api.backoffice.config.esindex.service;

import java.util.List;

import com.arms.api.backoffice.config.esindex.model.vo.IndexStatusSumVO;
import com.arms.api.backoffice.config.esindex.model.vo.IndexStatusesWithJobIdVO;
import com.arms.egovframework.javaservice.treeframework.controller.CommonResponse;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

import com.arms.api.util.communicate.external.EngineService;

import lombok.AllArgsConstructor;

@Service
@AllArgsConstructor
public class EsIndexConfigServiceImpl implements EsIndexConfigService{

	private final EngineService engineService;

	@Override
	public ResponseEntity<CommonResponse.ApiResult<List<IndexStatusSumVO>>> esIndexSumList() {
		return engineService.esIndexSumList();
	}

	@Override
	public ResponseEntity<CommonResponse.ApiResult<List<IndexStatusesWithJobIdVO>>> indexJobHistories() {
		return engineService.indexJobHistories();
	}


}
