package com.arms.api.blog.controller;

import com.arms.api.blog.model.BlogDTO;
import com.arms.api.blog.model.BlogEntity;
import com.arms.api.blog.model.BlogVO;
import com.arms.api.blog.service.BlogService;
import com.arms.egovframework.javaservice.treeframework.TreeConstant;
import com.arms.egovframework.javaservice.treeframework.controller.CommonResponse;
import com.arms.egovframework.javaservice.treeframework.controller.TreeAbstractController;
import com.arms.egovframework.javaservice.treeframework.util.EgovFileUploadUtil;
import com.arms.egovframework.javaservice.treeframework.util.EgovFormBasedFileVo;
import com.arms.egovframework.javaservice.treeframework.util.PropertiesReader;
import com.arms.egovframework.javaservice.treeframework.validation.group.AddNode;
import com.arms.egovframework.javaservice.treeframework.validation.group.UpdateNode;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.hibernate.criterion.*;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.servlet.ModelAndView;

import javax.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Slf4j
@Controller
@RestController
@RequiredArgsConstructor
@RequestMapping(value = {"/anonymous/arms/blog"})
public class BlogController extends TreeAbstractController<BlogService, BlogDTO, BlogEntity> {

    private final BlogService blogService;

    @PostConstruct
    public void initialize() {
        setTreeService(blogService);
        setTreeEntity(BlogEntity.class);
    }

    @GetMapping("/getBlog.do")
    public ResponseEntity<BlogDTO> getBlog(BlogDTO blogDTO) throws Exception {
        return ResponseEntity.ok(blogService.getBlog(blogDTO));
    }

    @PostMapping("/addBlog.do")
    public ResponseEntity<BlogEntity> addBlog(@RequestBody BlogDTO blogDTO) throws Exception {
        return ResponseEntity.ok(blogService.addBlog(blogDTO));
    }

    @PutMapping("/updateBlog.do")
    public ResponseEntity<BlogEntity> updateBlog(@RequestBody BlogDTO blogDTO) throws Exception {
        return ResponseEntity.ok(blogService.updateBlog(blogDTO));
    }

    @DeleteMapping("/removeBlog.do")
    public ResponseEntity<Integer> removeBlog(BlogDTO blogDTO) throws Exception {
        return ResponseEntity.ok(blogService.removeBlog(blogDTO));
    }

    @GetMapping("/latest/getBlogList.do")
    public ResponseEntity<List<BlogEntity>> getLatestBlogList(BlogDTO blogDTO) throws Exception {
        return ResponseEntity.ok(blogService.getLatestBlogList(blogDTO));
    }

    @GetMapping("/popular/getBlogList.do")
    public ResponseEntity<List<BlogDTO>> getPopularBlogList(BlogDTO blogDTO) throws Exception {
        return ResponseEntity.ok(blogService.getPopularBlogList(blogDTO));
    }

    @GetMapping("/recommended/getBlogList.do")
    public ResponseEntity<List<BlogEntity>> getRecommendedBlogList(BlogDTO blogDTO) throws Exception {
        return ResponseEntity.ok(blogService.getRecommendedBlogList(blogDTO));
    }

    @GetMapping("/getPaginatedBlogList.do")
    public ResponseEntity<Map<String, Object>> getPaginatedBlogList(BlogDTO blogDTO,
                                    @RequestParam(defaultValue = "1") int pageIndex,
                                    @RequestParam(defaultValue = "5") int pageUnit) throws Exception {
        return ResponseEntity.ok(blogService.getPaginatedBlogList(blogDTO, pageIndex, pageUnit));
    }

    @GetMapping("/hot/getKeywordList.do")
    public ResponseEntity<List<String>> getHotKeywordList() throws Exception {
        List<String> demoKeywords = new ArrayList<>();
        demoKeywords.add("일정 분석");
        demoKeywords.add("범위 분석");
        demoKeywords.add("자원 분석");
        demoKeywords.add("간트 분석");
        demoKeywords.add("요구 분석");
        demoKeywords.add("칸반 관리");
        demoKeywords.add("버전 맵핑");
        demoKeywords.add("인공지능 분석");
        return ResponseEntity.ok(demoKeywords);
    }

    @GetMapping("/searchBlogList.do")
    public ResponseEntity<BlogVO> searchBlogList(BlogDTO blogDTO) throws Exception {
        log.info("[BlogController :: searchBlogList ] :: blogDTO => {}", blogService.searchBlogList(blogDTO));
        return ResponseEntity.ok(blogService.searchBlogList(blogDTO));
    }

}
