package com.arms.api.blog.service;

import com.arms.api.blog.model.BlogDTO;
import com.arms.api.blog.model.BlogEntity;
import com.arms.api.blog.model.BlogVO;
import com.arms.egovframework.javaservice.treeframework.service.TreeService;

import java.util.List;
import java.util.Map;

public interface BlogService extends TreeService {

    BlogDTO getBlog(BlogDTO blogDTO) throws Exception;

    BlogEntity addBlog (BlogDTO blogDto) throws Exception;

    BlogEntity updateBlog (BlogDTO blogDto) throws Exception;

    int removeBlog (BlogDTO blogDto) throws Exception;

    List<BlogEntity> getLatestBlogList (BlogDTO blogDto) throws Exception;

    List<BlogDTO> getPopularBlogList (BlogDTO blogDto) throws Exception;

    Map<String, Object> getPaginatedBlogList (BlogDTO blogDto, int pageIndex, int pageUnit) throws Exception;

    List<BlogEntity> getRecommendedBlogList(BlogDTO blogDTO) throws Exception;

    BlogVO searchBlogList (BlogDTO blogDTO);
}