/*
 * @author Dongmin.lee
 * @since 2023-03-28
 * @version 23.03.28
 * @see <pre>
 *  Copyright (C) 2007 by 313 DEV GRP, Inc - All Rights Reserved
 *  Unauthorized copying of this file, via any medium is strictly prohibited
 *  Proprietary and confidential
 *  Written by 313 developer group <313@313.co.kr>, December 2010
 * </pre>
 */
package com.arms.api.jira.jiraissuestatuscategorymap.controller;

import com.arms.api.jira.jiraissuestatuscategorymap.model.JiraIssueStatusCategoryMapDTO;
import com.arms.api.jira.jiraissuestatuscategorymap.model.JiraIssueStatusCategoryMapEntity;
import com.arms.api.jira.jiraissuestatuscategorymap.service.JiraIssueStatusCategoryMap;
import com.arms.egovframework.javaservice.treeframework.controller.TreeAbstractController;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

import javax.annotation.PostConstruct;

@Slf4j
@Controller
@RequestMapping(value = {"/arms/jiraIssueStatusCategoryMap"})
public class JiraIssueStatusCategoryMapController extends TreeAbstractController<JiraIssueStatusCategoryMap, JiraIssueStatusCategoryMapDTO, JiraIssueStatusCategoryMapEntity> {

    @Autowired
    @Qualifier("jiraIssueStatusCategoryMap")
    private JiraIssueStatusCategoryMap jiraIssueStatusCategoryMap;

    @PostConstruct
    public void initialize() {
        setTreeService(jiraIssueStatusCategoryMap);
        setTreeEntity(JiraIssueStatusCategoryMapEntity.class);
    }

}
