/*
 * @author Dongmin.lee
 * @since 2023-03-21
 * @version 23.03.21
 * @see <pre>
 *  Copyright (C) 2007 by 313 DEV GRP, Inc - All Rights Reserved
 *  Unauthorized copying of this file, via any medium is strictly prohibited
 *  Proprietary and confidential
 *  Written by 313 developer group <313@313.co.kr>, December 2010
 * </pre>
 */
package com.arms.api.jira.jiraproject.controller;

import com.arms.api.jira.jiraproject.model.JiraProjectDTO;
import com.arms.api.jira.jiraproject.model.JiraProjectEntity;
import com.arms.api.jira.jiraproject.service.JiraProject;
import com.arms.api.jira.jiraserver.model.enums.EntityType;
import com.arms.egovframework.javaservice.treeframework.controller.CommonResponse;
import com.arms.egovframework.javaservice.treeframework.controller.TreeAbstractController;
import com.arms.egovframework.javaservice.treeframework.util.ParameterParser;
import com.arms.egovframework.javaservice.treeframework.util.StringUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;

@Slf4j
@Controller
@RequestMapping(value = {"/arms/jiraProject"})
public class JiraProjectController extends TreeAbstractController<JiraProject, JiraProjectDTO, JiraProjectEntity> {

    @Autowired
    @Qualifier("jiraProject")
    private JiraProject jiraProject;

    @PostConstruct
    public void initialize() {
        setTreeService(jiraProject);
        setTreeEntity(JiraProjectEntity.class);
    }

    @ResponseBody
    @RequestMapping(
            value = {"/getProjectIssueType.do"},
            method={RequestMethod.GET}
    )
    public ResponseEntity<?> getProjectIssueTypeList(HttpServletRequest request,
                                                     JiraProjectDTO jiraProjectDTO) throws Exception {


        ParameterParser parser = new ParameterParser(request);

        if (parser.getInt("c_id") <= 0) {
            throw new RuntimeException("c_id is minus value");
        }

        log.info("JiraProjectController :: getProjectIssueTypeList");
        JiraProjectEntity jiraProjectEntity = modelMapper.map(jiraProjectDTO, JiraProjectEntity.class);

        return ResponseEntity.ok(CommonResponse.success(jiraProject.프로젝트_이슈유형_리스트_조회(jiraProjectEntity)));
    }

    @ResponseBody
    @RequestMapping(
            value = {"/{defaultTarget}/makeDefault.do"},
            method = {RequestMethod.PUT}
    )
    public ResponseEntity<?> 클라우드서버_지라프로젝트_항목별_기본값_설정(HttpServletRequest request,
                                                    @PathVariable(name="defaultTarget") String 설정할_항목,
                                                    @RequestParam(name="targetCId") Long targetCId,
                                                    JiraProjectDTO jiraProjectDTO) throws Exception {

        ParameterParser parser = new ParameterParser(request);

        if (parser.getInt("c_id") <= 0) {
            throw new RuntimeException("c_id is minus value");
        }

        if (parser.getInt("targetCId") <= 0) {
            throw new RuntimeException("targetCId is minus value");
        }

        if (StringUtils.isEmpty(설정할_항목)) {
            throw new RuntimeException("PathVariable defaultTarget is empty");
        }

        log.info("JiraProjectController :: 클라우드서버_지라프로젝트_항목별_기본값_설정, 설정할_항목: {}, target_c_id: {}", 설정할_항목, targetCId);
        JiraProjectEntity jiraProjectEntity = modelMapper.map(jiraProjectDTO, JiraProjectEntity.class);

        EntityType 설정항목 = EntityType.fromString(설정할_항목);

        return ResponseEntity.ok(CommonResponse.success(jiraProject.프로젝트_항목별_기본값_설정(설정항목, targetCId, jiraProjectEntity)));
    }

}
