package com.arms.api.jira.jiraserver.model.enums;

public enum CacheType {

    ALM("alm"),
    ARMS_STATE("state"),
    ARMS_STATE_CATEGORY("category");

    private final String type;

    CacheType(String type) {
        this.type = type;
    }

    public String getType() {
        return type;
    }

    public static CacheType fromString(String type) {

        for (CacheType textFormattingType : CacheType.values()) {
            if (textFormattingType.getType().equals(type)) {
                return textFormattingType;
            }
        }

        throw new IllegalArgumentException("유효하지 않은 캐시 데이터 타입: " + type);
    }
}
