/*
 * @author Dongmin.lee
 * @since 2023-03-28
 * @version 23.03.28
 * @see <pre>
 *  Copyright (C) 2007 by 313 DEV GRP, Inc - All Rights Reserved
 *  Unauthorized copying of this file, via any medium is strictly prohibited
 *  Proprietary and confidential
 *  Written by 313 developer group <313@313.co.kr>, December 2010
 * </pre>
 */
package com.arms.api.jira.jiraserver_pure.controller;

import com.arms.api.jira.jiraserver.model.JiraServerDTO;
import com.arms.api.jira.jiraserver.model.AlmAccount;
import com.arms.api.jira.jiraserver_pure.model.JiraServerPureDTO;
import com.arms.api.jira.jiraserver_pure.model.JiraServerPureEntity;
import com.arms.api.jira.jiraserver_pure.model.VerifyALMAccountDTO;
import com.arms.api.jira.jiraserver_pure.service.JiraServerPure;
import com.arms.api.util.aes.AES256Decryption;
import com.arms.api.util.aes.AES256Encryption;
import com.arms.api.util.communicate.external.request.ServerInfo;
import com.arms.egovframework.javaservice.treeframework.controller.CommonResponse;
import com.arms.egovframework.javaservice.treeframework.controller.TreeAbstractController;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.*;

import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Map;

@Slf4j
@Controller
@RequestMapping(value = {"/arms/jiraServerPure"})
public class JiraServerPureController extends TreeAbstractController<JiraServerPure, JiraServerPureDTO, JiraServerPureEntity> {

    @Autowired
    @Qualifier("jiraServerPure")
    private JiraServerPure jiraServerPure;

    @PostConstruct
    public void initialize() {
        setTreeService(jiraServerPure);
        setTreeEntity(JiraServerPureEntity.class);
    }

    @Autowired
    AES256Decryption aes256Decryption;

    @Autowired
    AES256Encryption aes256Encryption;

    @ResponseBody
    @RequestMapping(
            value= { "/getNodeExceptPW.do"},
            method= {RequestMethod.GET}
    )
    public ResponseEntity<JiraServerPureEntity> getNodeWithoutPW(JiraServerPureDTO jiraServerPureDTO) throws Exception {

        log.info("JiraServerPureController :: getNodeWithoutPW");
        JiraServerPureEntity jiraServerPureEntity = modelMapper.map(jiraServerPureDTO, JiraServerPureEntity.class);

        JiraServerPureEntity fetchedEntity = jiraServerPure.getNode(jiraServerPureEntity);
        fetchedEntity.setC_jira_server_connect_pw(null);

        return ResponseEntity.ok(fetchedEntity);
    }

    @ResponseBody
    @PostMapping("/verifyAccount.do")
    public ResponseEntity<?> verifyALMAccount(@RequestBody VerifyALMAccountDTO accountDTO) {
        log.info("JiraServerController :: verifyALMAccount");

        try{
            return ResponseEntity.ok(CommonResponse.success(jiraServerPure.verifyExistingALMServerAccount(accountDTO)));
        } catch (Exception e) {
            log.error("[JiraServerController :: verifyALMAccount] :: error occurred :: {} ", e.getMessage());

            CommonResponse.ApiResult<?> errorResult = CommonResponse.error(e.getMessage(), HttpStatus.BAD_REQUEST);
            return new ResponseEntity<>(errorResult, HttpStatus.BAD_REQUEST);
        }
    }

    @ResponseBody
    @PostMapping("/verifyNewAccount.do")
    public ResponseEntity<?> verifyNewALMAccount(@RequestBody VerifyALMAccountDTO accountDTO) {

        log.info("JiraServerController :: verifyNewALMAccount");

        try{
            return ResponseEntity.ok(CommonResponse.success(jiraServerPure.verifyNewALMServerAccount(accountDTO)));
        } catch (Exception e) {
            log.error("[JiraServerController :: verifyNewALMAccount] :: error occurred :: {} ", e.getMessage());

            CommonResponse.ApiResult<?> errorResult = CommonResponse.error(e.getMessage(), HttpStatus.BAD_REQUEST);
            return new ResponseEntity<>(errorResult, HttpStatus.BAD_REQUEST);
        }
    }

    @ResponseBody
    @RequestMapping(
            value= { "/getNodeWithDecryption.do"},
            method= {RequestMethod.GET}
    )
    public ResponseEntity<JiraServerPureEntity> getNodeWithDecryption(JiraServerPureDTO jiraServerPureDTO) throws Exception {

        log.info("JiraServerPureController :: getNodeWithDecryption");
        JiraServerPureEntity jiraServerPureEntity = modelMapper.map(jiraServerPureDTO, JiraServerPureEntity.class);

        JiraServerPureEntity fetchedEntity = jiraServerPure.getNode(jiraServerPureEntity);
        log.info("[JiraServerPureController :: getNodeWithDecryption] :: fetchedEntity.connectId => {}, fetchedEntity.connectPw => {}",
                fetchedEntity.getC_jira_server_connect_id(), fetchedEntity.getC_jira_server_connect_pw());
        String decryptedAlmConnectId = fetchedEntity.getC_jira_server_connect_id();
        String decryptedAlmConnectPw = aes256Decryption.decrypt(fetchedEntity.getC_jira_server_connect_pw());
        log.info("[JiraServerPureController :: getNodeWithDecryption] :: fetchedEntity.decryptedAlmConnectId => {}, fetchedEntity.decryptedAlmConnectPw => {}",
                decryptedAlmConnectId, decryptedAlmConnectPw);
        fetchedEntity.setC_jira_server_connect_id(decryptedAlmConnectId);
        fetchedEntity.setC_jira_server_connect_pw(decryptedAlmConnectPw);

        return ResponseEntity.ok(fetchedEntity);
    }


    @ResponseBody
    @GetMapping(
            value= { "/getJiraServerMonitor.do"}
    )
    public ResponseEntity<List<JiraServerPureEntity>> getJiraServerMonitor(JiraServerDTO jiraServerDTO, ModelMap model, HttpServletRequest request) throws Exception {

        log.info("JiraServerPureController :: getJiraServerMonitor");
        JiraServerPureEntity jiraServerEntity = modelMapper.map(jiraServerDTO, JiraServerPureEntity.class);

        return ResponseEntity.ok(jiraServerPure.getNodesWithoutRoot(jiraServerEntity));
    }

    @ResponseBody
    @RequestMapping(
            value= { "/serverTypeMap.do"},
            method= {RequestMethod.GET}
    )
    public ResponseEntity<Map<String, String>> getServerTypeMap(JiraServerDTO jiraServerDTO, ModelMap model, HttpServletRequest request) throws Exception {

        log.info("JiraServerPureController :: getServerTypeMap");
        return ResponseEntity.ok(jiraServerPure.ALM서버_아이디_서버유형_맵_가져오기());
    }

    @ResponseBody
    @RequestMapping(
            value= { "/makeEncryption.do"},
            method= {RequestMethod.GET}
    )
    public ResponseEntity<String> makeEncryption(String str) throws Exception {

        log.info("JiraServerPureController :: getServerTypeMap");
        return ResponseEntity.ok(aes256Encryption.encrypt(str));
    }

}
