package com.arms.api.jira.jiraserver_pure.service;


import com.arms.api.jira.jiraserver.model.AlmAccount;
import com.arms.api.jira.jiraserver_pure.model.JiraServerPureEntity;
import com.arms.api.jira.jiraserver_pure.model.VerifyALMAccountDTO;
import com.arms.api.util.aes.AES256Encryption;
import com.arms.api.util.communicate.external.EngineService;
import com.arms.api.util.communicate.external.request.ServerInfo;
import com.arms.egovframework.javaservice.treeframework.TreeConstant;
import com.arms.egovframework.javaservice.treeframework.service.TreeServiceImpl;
import lombok.AllArgsConstructor;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Map;

@AllArgsConstructor
@Service("jiraServerPure")
public class JiraServerPureImpl extends TreeServiceImpl implements JiraServerPure {

    @Autowired
    private EngineService engineService;
    @Autowired
    private AES256Encryption aes256Encryption;


    @Override
    public Map<String, String> ALM서버_아이디_서버유형_맵_가져오기() {
        return engineService.서버_연결아이디_유형정보_맵_조회();
    }

    @Override
    @Transactional(readOnly = true)
    public List<JiraServerPureEntity> getNodesWithoutRoot(JiraServerPureEntity jiraServerPureEntity) throws Exception {
        jiraServerPureEntity.setOrder(Order.desc("c_id"));
        Criterion criterion = Restrictions.not(
                Restrictions.in("c_id", new Object[]{TreeConstant.ROOT_CID, TreeConstant.First_Node_CID})
        );
        jiraServerPureEntity.getCriterions().add(criterion);

        return this.getChildNode(jiraServerPureEntity);
    }

    @Override
    public AlmAccount verifyNewALMServerAccount(VerifyALMAccountDTO accountDTO) {

        ServerInfo serverInfo = ServerInfo.builder()
                .uri(accountDTO.getUri())
                .type(accountDTO.getType())
                .userId(accountDTO.getUserId())
                .passwordOrToken(aes256Encryption.encrypt(accountDTO.getPasswordOrToken()))
                .build();
        return engineService.verifyAccount(serverInfo).getBody();
    }

    @Override
    public AlmAccount verifyExistingALMServerAccount(VerifyALMAccountDTO accountDTO) throws Exception {
        JiraServerPureEntity entityForSearch = new JiraServerPureEntity();
        entityForSearch.setC_id(accountDTO.getServerCId());
        JiraServerPureEntity fetchedEntity = this.getNode(entityForSearch);

        String encryptedPW = fetchedEntity.getC_jira_server_connect_pw();

        ServerInfo serverInfo = ServerInfo.builder()
                .uri(accountDTO.getUri())
                .type(accountDTO.getType())
                .userId(accountDTO.getUserId())
                .passwordOrToken(encryptedPW)
                .build();

        return engineService.verifyAccount(serverInfo).getBody();
    }

}
