package com.arms.api.newsletter.service;

import com.arms.api.newsletter.model.NewsletterDTO;
import com.arms.api.newsletter.model.NewsletterEntity;
import com.arms.egovframework.javaservice.treeframework.service.TreeService;

import java.util.List;

public interface Newsletter extends TreeService {

    NewsletterEntity addNewsletter(NewsletterEntity newsletterEntity) throws Exception;

    NewsletterEntity getNewsletter(Long newsletterId) throws Exception;

    NewsletterEntity updateNewsletter(NewsletterEntity newsletterEntity) throws Exception;

    NewsletterEntity removeNewsletter(Long newsletterId) throws Exception;

    Long getNewsletterCount(NewsletterEntity newsletterEntity) throws Exception;

    List<NewsletterDTO> getNewsletters(NewsletterEntity newsletterEntity, int pageIndex, int pageUnit) throws Exception;

    List<NewsletterDTO> getPopularNewsletters(NewsletterEntity newsletterEntity, int pageIndex, int pageUnit) throws Exception;

}
