package com.arms.api.poc.controller;

import com.arms.api.poc.model.PocDTO;
import com.arms.api.poc.model.PocEntity;
import com.arms.api.poc.model.vo.PocVO;
import com.arms.api.poc.service.PocService;
import com.arms.egovframework.javaservice.treeframework.controller.CommonResponse;
import com.arms.egovframework.javaservice.treeframework.validation.group.AddNode;
import com.arms.egovframework.javaservice.treeframework.validation.group.UpdateNode;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

@Slf4j
@RestController
@RequiredArgsConstructor
@RequestMapping(value = {"/anonymous/arms/poc"})
public class PocController {

    private final PocService pocService;

    @PostMapping("/addPoc.do")
    public ResponseEntity<?> addPoc(@Validated({AddNode.class}) PocDTO pocDTO) throws Exception {
        return ResponseEntity.ok(CommonResponse.success(pocService.addPoc(pocDTO)));
    }

    @GetMapping("/getPoc.do/{pocId}")
    public ResponseEntity<?> getPoc(@PathVariable("pocId") String pocId) throws Exception {
        return ResponseEntity.ok(CommonResponse.success(pocService.getPoc(pocId)));
    }

    @GetMapping("/getPocList.do")
    public ResponseEntity<CommonResponse.ApiResult<PocVO>> getPocList(PocDTO pocDTO) throws Exception {
        return ResponseEntity.ok(CommonResponse.success(pocService.getPocList(pocDTO)));
    }

    @PutMapping("/updatePoc.do")
    public ResponseEntity<CommonResponse.ApiResult<Integer>> updatePoc(@Validated({UpdateNode.class}) PocDTO pocDTO) throws Exception {
        return ResponseEntity.ok(CommonResponse.success(pocService.updatePoc(pocDTO)));
    }

    @DeleteMapping("/removePoc.do/{pocId}")
    public ResponseEntity<CommonResponse.ApiResult<Integer>> removePoc(@PathVariable("pocId") String pocId) throws Exception {
        return ResponseEntity.ok(CommonResponse.success(pocService.removePoc(pocId)));
    }
}
