package com.arms.api.report.export_service.dto;

import com.arms.api.report.export_service.enums.ExportType;
import lombok.Builder;
import lombok.Getter;

import java.time.LocalDateTime;

/**
 * 리포트 내보내기 응답 DTO
 *
 * @author HS.Yang
 * @since 25.12.03
 */
@Getter
@Builder
public class ReportExportResponse {

    /** 성공 여부 */
    private boolean success;

    /** 메시지 */
    private String message;

    /** 리포트 ID */
    private String reportId;

    /** 파일명 */
    private String fileName;

    /** 내보내기 타입 */
    private ExportType exportType;

    /** 파일 크기 (bytes) */
    private long fileSizeBytes;

    /** 생성 시간 */
    private LocalDateTime generatedAt;

    /** 다운로드 URL (비동기용) */
    private String downloadUrl;

    /** 에러 코드 */
    private String errorCode;

    /** 에러 상세 */
    private String errorDetail;

    /**
     * 성공 응답 생성
     */
    public static ReportExportResponse success(String reportId,
                                                String fileName,
                                                ExportType type,
                                                long size) {
        return ReportExportResponse.builder()
                .success(true)
                .message("Report generated successfully")
                .reportId(reportId)
                .fileName(fileName)
                .exportType(type)
                .fileSizeBytes(size)
                .generatedAt(LocalDateTime.now())
                .build();
    }

    /**
     * 실패 응답 생성
     */
    public static ReportExportResponse failure(String errorCode, String errorDetail) {
        return ReportExportResponse.builder()
                .success(false)
                .message("Report generation failed")
                .errorCode(errorCode)
                .errorDetail(errorDetail)
                .generatedAt(LocalDateTime.now())
                .build();
    }
}
