package com.arms.api.report.export_service.exception;

import lombok.Getter;

/**
 * 템플릿 미발견 예외
 *
 * @author HS.Yang
 * @since 25.12.03
 */
@Getter
public class TemplateNotFoundException extends ReportExportException {

    private final String templateName;

    public TemplateNotFoundException(String templateName) {
        super("TEMPLATE_NOT_FOUND", "Template not found: " + templateName);
        this.templateName = templateName;
    }

    public TemplateNotFoundException(String templateName, Throwable cause) {
        super("TEMPLATE_NOT_FOUND", "Template not found: " + templateName, cause);
        this.templateName = templateName;
    }
}
