package com.arms.api.report.fulldata.controller;

import com.arms.api.report.fulldata.model.ExcelDataDTO;
import com.arms.api.report.fulldata.model.FullDataRequestDTO;
import com.arms.api.report.fulldata.model.작업자_정보;
import com.arms.api.report.fulldata.service.FullDataService;
import com.arms.egovframework.javaservice.treeframework.controller.CommonResponse;
import com.arms.egovframework.javaservice.treeframework.excel.ExcelUtilsBase;
import com.arms.egovframework.javaservice.treeframework.excel.ExcelUtilsFactory;

import feign.Param;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

@Slf4j
@RestController
@RequiredArgsConstructor
@RequestMapping(value = {"/arms/report/full-data"})
public class FullDataController {

    private final FullDataService fullDataService;

    @GetMapping("/assignee-list")
    public ResponseEntity<CommonResponse.ApiResult<List<작업자_정보>>> getAssignees() throws Exception {
        List<작업자_정보> assigneeList = fullDataService.getAssigneeList();
        return ResponseEntity.ok(CommonResponse.success(assigneeList));
    }

    @GetMapping("/excel-data")
    public ResponseEntity<CommonResponse.ApiResult<List<ExcelDataDTO>>> getExcelData(
            FullDataRequestDTO fullDataRequestDTO) throws Exception {
        List<ExcelDataDTO> response = fullDataService.getExcelData(fullDataRequestDTO);
        return ResponseEntity.ok(CommonResponse.success(response));
    }

    @GetMapping("/excel-data-down")
    public void getExcelDataDown(
            FullDataRequestDTO fullDataRequestDTO,
            @Param("fileName") String fileName,
            HttpServletResponse httpServletResponse) throws Exception {

        httpServletResponse.addHeader(HttpHeaders.CONTENT_DISPOSITION, "attachment; filename=" + fileName);
        httpServletResponse.addHeader("Cache-Control", "no-cache, no-store, must-revalidate");
        httpServletResponse.addHeader("Pragma", "no-cache");
        httpServletResponse.addHeader("Expires", "0");
        httpServletResponse.setContentType("application/octet-stream");

        ExcelUtilsBase excelUtilsBase = ExcelUtilsFactory.getInstance(
                httpServletResponse.getOutputStream());

        List<ExcelDataDTO> excelDataDown = fullDataService.getExcelDataDown(fullDataRequestDTO);
        log.info("[ FullDataController :: getExcelDataDown ] :: excelData.count=> {}", excelDataDown.size());

        excelUtilsBase.create(List.of(excelDataDown));
    }

}
