package com.arms.api.requirement.reqstatus.model;

import com.arms.api.util.communicate.external.response.jira.AlmIssue;
import lombok.*;

import java.util.ArrayList;
import java.util.List;

@Builder
@Getter
@AllArgsConstructor
@NoArgsConstructor
public class HierarchicalAlmIssue {

    AlmIssue almIssue;

    @Setter
    private String pdServiceVersionNames;
    private String isReqName;
    private Long linkedIssueCount; // 연결된 이슈 수
    private Long subtaskCount; // 하위이슈 수

    List<HierarchicalAlmIssue> children;

    public void updateReqName(String isReqName) {
        this.isReqName = isReqName;
    }

    public HierarchicalAlmIssue (HierarchicalAlmIssue other) {
        this.almIssue = other.almIssue;
        this.isReqName = other.isReqName;
        this.pdServiceVersionNames = other.pdServiceVersionNames;
        this.children = new ArrayList<>(other.children);

    }

}
