package com.arms.api.requirement.reqstatus_calendar.controller;


import com.arms.api.requirement.reqstatus_calendar.model.CalendarDataDTO;
import com.arms.api.requirement.reqstatus_calendar.model.ReqStatusCalendarRequestDTO;
import com.arms.api.requirement.reqstatus_calendar.service.ReqStatusCalendarService;
import com.arms.egovframework.javaservice.treeframework.controller.CommonResponse;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@Slf4j
@RestController
@RequiredArgsConstructor
@RequestMapping(value = {"/arms/reqStatus/calendar"})
public class ReqStatusCalendarController {

    private final ReqStatusCalendarService reqStatusCalendarService;


    @GetMapping
    public ResponseEntity<CommonResponse.ApiResult<List<CalendarDataDTO>>> getCalendarData(
            ReqStatusCalendarRequestDTO reqStatusCalendarRequestDTO) throws Exception {
        List<CalendarDataDTO> response = reqStatusCalendarService.getCalendarData(reqStatusCalendarRequestDTO);
        return ResponseEntity.ok(CommonResponse.success(response));
    }

}

