package com.arms.api.util;

public class RangeUtil {

    /**
     * Ensures the input value is not less than the minimum value.
     * @param input the value to compare
     * @param min   the minimum value
     * @return      the greater of input and min
     */
    public static Long clampMin(Long input, Long min) {
        if (input < min) {
            return min;
        }
        return input;
    }

    /**
     * Ensures the input value is not greater than the maximum value.
     * @param input the value to compare
     * @param max   the maximum value
     * @return      the lesser of input and max
     */
    public static Long clampMax(Long input, Long max) {
        if (input > max) {
            return max;
        }
        return input;
    }

    /**
     * Ensures the input value is not less than the minimum value.
     * If the input value is less than the specified minimum, the input value is returned.
     * Otherwise, the minimum value is returned.
     *
     * @param input the value to compare
     * @param min   the minimum value
     * @return      the greater of input and min
     */
    public static Long returnIfLess(Long input, Long min) {
        if (input < min) {
            return input;
        }
        return min;
    }

    /**
     * Ensures the input value is not greater than the maximum value.
     * If the input value is greater than the specified maximum, the input value is returned.
     * Otherwise, the maximum value is returned.
     *
     * @param input the value to compare
     * @param max   the maximum value
     * @return      the lesser of input and max
     */
    public static Long returnIfGreater(Long input, Long max) {
        if (input > max) {
            return input;
        }
        return max;
    }
}
