package com.arms.api.util.communicate.external;

import com.arms.api.analysis.cost.model.dto.CostDTO;
import com.arms.api.analysis.cost.model.vo.AssigneeTimeDiffVO;
import com.arms.api.analysis.cost.model.vo.CostVO;
import com.arms.api.analysis.resource.model.dto.ResourceDTO;
import com.arms.api.analysis.resource.model.dto.ResourceWithVersionIdNamesDTO;
import com.arms.api.analysis.resource.model.vo.StackedHorizontalBarChartVO;
import com.arms.api.analysis.resource.model.vo.UniqueAssigneeIssueStatusVO;
import com.arms.api.analysis.resource.model.vo.UniqueAssigneeVO;
import com.arms.api.analysis.resource.model.vo.horizontalbar.HorizontalBarChartYAxisAndSeriesVO;
import com.arms.api.analysis.resource.model.vo.horizontalbar.ReqAndNotReqHorizontalBarChartVO;
import com.arms.api.analysis.resource.model.vo.pie.ReqAndNotReqPieChartVO;
import com.arms.api.analysis.resource.model.vo.pie.TotalIssueAndPieChartVO;
import com.arms.api.analysis.resource.model.vo.sankey.SankeyChartBaseVO;
import com.arms.api.analysis.resource.model.vo.treemap.TreeMapWorkerVO;
import com.arms.api.analysis.resource.model.vo.treemap.TreemapExcelVO;
import com.arms.api.analysis.resource.model.vo.wordcloud.WordCloudExcelVO;
import com.arms.api.analysis.scope.model.dto.ScopeDTO;
import com.arms.api.analysis.scope.model.vo.*;
import com.arms.api.analysis.time.model.RidgeLineVO;
import com.arms.api.analysis.time.model.dto.TimeDTO;
import com.arms.api.analysis.time.model.vo.AlmIssueStatVO;
import com.arms.api.analysis.topmenu.model.dto.TopMenuAnalysisDTO;
import com.arms.api.analysis.topmenu.model.vo.ReqAndIssueTotalCountVO;
import com.arms.api.dashboard.model.RequirementJiraIssueAggregationResponse;
import com.arms.api.dashboard.model.dto.DashboardDTO;
import com.arms.api.dashboard.model.vo.TopNReqAssigneeReqLinkVO;
import com.arms.api.dashboard.model.vo.TopNReqAssigneeVO;
import com.arms.api.requirement.reqadd.model.dto.ReqAnalysisDTO;
import com.arms.api.requirement.reqadd_state_pure.model.vo.ReqProgressVO;
import com.arms.api.util.communicate.external.response.jira.AlmIssue;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Map;

@FeignClient(name = "engine-dashboard", url = "${arms.engine.url}")
public interface AggregationService {

    @PostMapping("/engine/dashboard/aggregate-weekly-req-issue-status")
    ResponseEntity<Map<String, RequirementJiraIssueAggregationResponse>> aggregateWeeklyReqIssueStatus(
            @RequestBody DashboardDTO dashboardDTO);

    // 대시보드-우하단 왼쪽 (인력별 요구사항)
    @PostMapping(value="/engine/dashboard/top-req-assignee")
    List<TopNReqAssigneeVO> topNReqAssignee(@RequestBody DashboardDTO dashboardDTO, @RequestParam Integer topN);

    // 대시보드-우하단 오른쪽 (인력별 요구사항 상태)
    @PostMapping(value = "/engine/dashboard/top-req-assignee-links")
    List<TopNReqAssigneeReqLinkVO> topNAssigneeReqLinks(@RequestBody DashboardDTO dashboardDTO, @RequestParam Integer topN);

    // 반환값 변경필요(DocumentAggregation) - reqAddStatePure - reqProgress 에서 사용중임
    // 매개변수로 resolution 에 null / "resolutiondate" 2가지 사용
    @PostMapping("/engine/req-gantt/resolution")
    ResponseEntity<List<ReqProgressVO>> 제품서비스_일반_버전_해결책유무_통계_V2(
            @RequestBody ReqAnalysisDTO reqAnalysisDTO,
            @RequestParam String resolution
    );

    /*
     * analysis-cost API
     * */
    @PostMapping("/engine/analysis-cost/aggregation/assignee-account-id")
    ResponseEntity<List<CostVO>> aggregationByAssigneeAccountId(
            @RequestBody CostDTO costDTO
    );

    @PostMapping("/engine/analysis-cost/aggregation/assignee-account-id-and-req-link")
    ResponseEntity<List<CostVO>> aggregationByReqLinkAndAssigneeAccountId(
            @RequestBody CostDTO costDTO
    );
    /**
     * 총 4depth 까지의 nested aggregation 처리
     * pdServiceVersions > isReq > assignee_accountId > assignee_displayName
     */
    @PostMapping("/engine/analysis-cost/assignee-list")
    ResponseEntity<List<CostVO>> getAssigneeList(@RequestBody CostDTO costDTO);

    @PostMapping("/engine/analysis-cost/version-requirement/assignee-list")
    ResponseEntity<List<CostVO>> getAssigneeListByProductVersionAndRequirement(@RequestBody CostDTO costDTO);

    @PostMapping("/engine/analysis-cost/calculateWorkdayByAccountId")
    List<AssigneeTimeDiffVO> calculateWorkdayByAccountId(@RequestBody CostDTO costDTO);


    /*
     * analysis-resource API
     * */
    @PostMapping("/engine/analysis-resource/word-cloud-data")
    List<WordCloudExcelVO> wordCloudData(@RequestBody ResourceDTO resourceDTO);

    @PostMapping("/engine/analysis-resource/issue-status-stacked-bar")
    StackedHorizontalBarChartVO issueStatusStackedBarChartData(@RequestBody ResourceDTO resourceDTO);

    @PostMapping("/engine/analysis-resource/top-contributors/pie")
    ReqAndNotReqPieChartVO findPieChartData(@RequestBody ResourceDTO resourceDTO);

    @PostMapping("/engine/analysis-resource/top-contributors/pie-expand")
    TotalIssueAndPieChartVO findPieChartDataExpand(@RequestBody ResourceDTO resourceDTO);

    @PostMapping("/engine/analysis-resource/top-contributors/horizontal-bar")
    List<HorizontalBarChartYAxisAndSeriesVO> findHorizontalBarChartData(@RequestBody ResourceDTO resourceDTO);

    @PostMapping("/engine/analysis-resource/top-contributors/horizontal-bar-at-once")
    ReqAndNotReqHorizontalBarChartVO findHorizontalBarChartDataBySameAccounts(@RequestBody ResourceDTO resourceDTO);

    // issue-status by Assignee (datatable)
    @PostMapping("/engine/analysis-resource/issue-status-by-assignee")
    List<UniqueAssigneeIssueStatusVO> issueStatusDataByAssignee(@RequestBody ResourceDTO resourceDTO);

    // sankey chart for resource
    @PostMapping("/engine/analysis-resource/version-assignee-summary")
    List<SankeyChartBaseVO> findVersionAssigneeSummaryData(@RequestBody ResourceDTO resourceDTO);

    // expand - 작업자 조회
    @PostMapping("/engine/analysis-resource/assignees-info")
    ResponseEntity<List<UniqueAssigneeVO>> findAssigneesInfo(@RequestBody ResourceDTO resourceDTO);

    //resource-treemap
    @PostMapping("/engine/analysis-resource/assignees-requirements-involvements-v3")
    ResponseEntity<List<TreeMapWorkerVO>> findTreeMapChartDataV3(
            @RequestBody ResourceWithVersionIdNamesDTO resourceWithVersionIdNamesDTO
    );

    //resource-treemap-excel
    @PostMapping("/engine/analysis-resource/assignees-requirements-involvement-data")
    ResponseEntity<List<TreemapExcelVO>> findAssigneeRequirementInvolvementData(@RequestBody ResourceWithVersionIdNamesDTO resourceWithVersionIdNamesDTO);

    /*
     * analysis-scope API
     * */
    // 트리바 데이터 조회
    @PostMapping("/engine/analysis-scope/tree-bar-data-v2")
    ResponseEntity<List<TreeBarIssueVO>> treeBarData(@RequestBody ScopeDTO scopeDTO);

    // 네트워크 차트 조회
    @PostMapping("/engine/analysis-scope/getPdServiceVersionsAndReq")
    List<PdServiceVersionsAndReqVO> getPdServiceVersionsAndReq(ScopeDTO scopeDto);

    @PostMapping("/engine/analysis-scope/getVersionsAndIssueList")
    List<IssueVO> getVersionsAndIssueList(@RequestBody ScopeDTO scopeDTO);

    @PostMapping("/engine/analysis-scope/getIssueList")
    List<IssueVO> getIssueList(@RequestBody ScopeDTO scopeDTO);

    @PostMapping("/engine/analysis-scope/getNetworkChartExcelData")
    List<NetworkChartExcelDataVO> getNetworkChartExcelData(@RequestBody ScopeDTO scopeDTO);

    // circular-packing-chart data
    @PostMapping("/engine/analysis-scope/circular-packing-data")
    List<CircularPackingChartVO> getCircularPackingChartData(@RequestBody ScopeDTO scopeDTO);

    @PostMapping("/engine/analysis-scope/getDataTableIssues")
    List<ReqDataTableIssuesVO> getDataTableIssues(@RequestBody ScopeDTO scopeDTO);
    /*
     * analysis-time API
     * */
    // 멀티콤비네이션차트
    @PostMapping("/engine/analysis-time/updated-issue/multi-combination-data")
    ResponseEntity<List<AlmIssueStatVO>> getMultiCombinationChartData(
            @RequestBody TimeDTO timeDTO);
    // vertical-timeline
    @PostMapping("/engine/analysis-time/updated-timeline")
    ResponseEntity<List<AlmIssue>> getUpdatedIssueByDateRange(
            @RequestBody TimeDTO timeDTO);
    // ridgeline
    @PostMapping("/engine/analysis-time/updated-ridgeline")
    ResponseEntity<List<RidgeLineVO>> getRidgeLineData(@RequestBody TimeDTO timeDTO);
    /*
     * analysis-top-menu API
     * */
    @PostMapping(value = "/engine/analysis-top-menu/totalCountWithReqAndSubtask")
    ResponseEntity<ReqAndIssueTotalCountVO> topMenuTotalCountWithReqAndSubtask(@RequestBody TopMenuAnalysisDTO topMenuAnalysisDTO);

}
