package com.arms.api.util.communicate.internal;

import com.arms.api.product_service.pdservice.model.PdServiceAndVersionListDTO;
import com.arms.api.requirement.reqadd.model.vo.ReqAddVO;
import com.arms.api.requirement.reqadd.model.dto.ReqAddDTO;
import com.arms.api.requirement.reqstatus.model.ReqStatusDTO;
import com.arms.api.requirement.reqstatus.model.ReqStatusEntity;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@FeignClient(name = "loopback", url = "http://127.0.0.1:31313")
public interface InternalService {

    @GetMapping("/arms/reqAdd/{changeReqTableName}/getNodeDetail.do")
    ResponseEntity<ReqAddVO> 요구사항조회(@PathVariable(value = "changeReqTableName") String changeReqTableName,
            @RequestParam(value = "c_id") Long c_id);

    @GetMapping("/arms/reqAdd/{changeReqTableName}/getNodesWhereInIds.do")
    ResponseEntity<List<ReqAddVO>> reqAddList(
            @PathVariable(value = "changeReqTableName") String changeReqTableName,
            @RequestParam List<Long> ids
    );

    @GetMapping("/arms/reqAdd/{changeReqTableName}/getReqNodesWithoutRoot.do")
    ResponseEntity<?> getReqNodesWithoutRoot(
            @PathVariable(value = "changeReqTableName") String changeReqTableName
    );

    @PostMapping("/arms/reqAdd/{changeReqTableName}/addNode.do")
    ResponseEntity<?> create(@PathVariable(value = "changeReqTableName") String changeReqTableName,
                             @RequestBody ReqAddDTO reqAddDTO);

    @PostMapping("/arms/reqAdd/{changeReqTableName}/updateNode.do")
    ResponseEntity<?> update(@PathVariable(value = "changeReqTableName") String changeReqTableName,
                             @RequestBody ReqAddDTO reqAddDTO);

    @DeleteMapping("/arms/reqAdd/{changeReqTableName}/removeNode.do")
    ResponseEntity<?> delete(@PathVariable(value = "changeReqTableName") String changeReqTableName,
                             @RequestBody ReqAddDTO reqAddDTO);

    @PostMapping("/arms/reqAdd/{changeReqTableName}/updateReqAddOnly.do")
    ResponseEntity<?> 요구사항_수정하기(@PathVariable(value = "changeReqTableName") String changeReqTableName,
                                @RequestBody ReqAddDTO reqAddDTO);

    @PutMapping("/arms/reqAdd/{changeReqTableName}/updateReqAddState.do")
    ResponseEntity<?> 전체_요구사항_상태변경(@PathVariable(value = "changeReqTableName") String changeReqTableName,
                                @RequestParam Long stateBeforeChange, @RequestParam Long stateAfterChange);

    @PostMapping("/arms/reqStatus/{changeReqTableName}/addStatusNode.do")
    ResponseEntity<?> 요구사항_상태_정보_저장하기(@PathVariable(value = "changeReqTableName") String changeReqTableName,
                                      @RequestBody ReqStatusDTO reqStatusDTO);

    @GetMapping("/arms/reqStatus/{changeReqTableName}/getStatusMonitor.do")
    List<ReqStatusEntity> 제품별_요구사항_상황_조회(@PathVariable(value = "changeReqTableName") String changeReqTableName,
                                         @SpringQueryMap ReqStatusDTO reqStatusDTO);

    @PutMapping("/arms/reqStatus/{changeReqTableName}/updateStatusNode.do")
    ResponseEntity<?> 요구사항_상황_수정하기(@PathVariable(value = "changeReqTableName") String changeReqTableName,
                                   @RequestBody ReqStatusDTO reqStatusDTO);

    @DeleteMapping("/arms/reqStatus/{changeReqTableName}/removeNode.do")
    ResponseEntity<?> 요구사항_상황_삭제하기(@PathVariable(value = "changeReqTableName") String changeReqTableName,
                                   @RequestBody ReqStatusDTO reqStatusDTO);

    @GetMapping("/arms/reqStatus/{changeReqTableName}/getReqStatusListByCReqLink.do")
    ResponseEntity<List<ReqStatusEntity>> REQSTATUS_CID_요구사항_이슈_조회(@PathVariable(value = "changeReqTableName") String changeReqTableName,
                                                                   @SpringQueryMap ReqStatusDTO reqStatusDTO);

    @GetMapping("/arms/reqStatus/{changeReqTableName}/getStatusNode.do")
    ResponseEntity<List<ReqStatusEntity>> getStatusNode(@PathVariable(value = "changeReqTableName") String changeReqTableName,
                                                                   @SpringQueryMap ReqStatusDTO reqStatusDTO);

    @PostMapping("/arms/reqStatus/{changeReqTableName}/reqStatusCheckAfterAlmProcess.do")
    ResponseEntity<?> 요구사항_상태_확인후_ALM처리_및_REQSTATUS_업데이트(@PathVariable(value = "changeReqTableName") String changeReqTableName,
                                      @RequestBody ReqStatusDTO reqStatusDTO);

    @GetMapping("/arms/pdService/getPdServiceEntityAndVersionList")
    ResponseEntity<List<PdServiceAndVersionListDTO>> getPdServiceEntityAndVersionList();

}
