package com.arms.api.util.dynamicscheduler.controller;

import com.arms.api.util.communicate.external.response.jira.AlmIssue;
import com.arms.api.util.dynamicscheduler.service.ReqStatusSyncService;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.annotation.Async;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@Slf4j
@RestController
@RequestMapping(value = {"/arms/reqStatusSync"})
@AllArgsConstructor
public class ReqStatusSyncController {

    private final ReqStatusSyncService reqStatusSyncService;

    @PostMapping(value = {"/es-to-db"})
    public void 엔진수집결과_동기화(@RequestBody List<AlmIssue> almIssues) throws Exception {
        log.info("[ ReqStatusSyncController :: 엔진수집결과_동기화 ] :: 엔진 수집 결과 동기화 시작, 이슈 수 = {}", almIssues.size());
        reqStatusSyncService.엔진수집결과_동기화(almIssues);
    }

}