/*
 * @author Dongmin.lee
 * @since 2023-03-20
 * @version 23.03.20
 * @see <pre>
 *  Copyright (C) 2007 by 313 DEV GRP, Inc - All Rights Reserved
 *  Unauthorized copying of this file, via any medium is strictly prohibited
 *  Proprietary and confidential
 *  Written by 313 developer group <313@313.co.kr>, December 2010
 * </pre>
 */
package com.arms.api.util.dynamicscheduler.controller;

import com.arms.api.util.dynamicscheduler.service.SchedulerService;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import static com.arms.api.util.dynamicscheduler.model.SchedulerType.*;

@Slf4j
@RestController
@RequestMapping(value = {"/arms/scheduler"})
@AllArgsConstructor
public class SchedulerController {

    private final SchedulerService schedulerService;

    @GetMapping(
            value = {"/pdservice/reqstatus/executeSequentialSchedules/storeToES"}
    )
    public void executeSequentialSchedules() throws Exception {
        log.info("[ SchedulerController :: executeSequentialSchedules ] :: 전체 이슈 수집 요청");
        schedulerService.discoverByFullDateRange(REQUIREMENT_ISSUE_BULK_SAVE);
    }

    @GetMapping(
            value = {"/pdservice/reqstatus/increment/executeSequentialSchedules/storeToES"}
    )
    public void executeIncrementalIssueSequentialSchedules() throws Exception {
        log.info("[ SchedulerController :: executeIncrementalIssueSequentialSchedules ] :: 이슈 증분 수집 요청");
        schedulerService.discoverByPreviousDay(INCREMENTAL_ISSUE_BULK_SAVE);
    }


    @GetMapping(
            value = {"/pdservice/reqstatus/increment/executeSequentialSchedules/storeToES/withDateRange"}
    )
    public void executeIncrementalIssueWithDateRangeSequentialSchedules(@RequestParam(value = "startDate",required = false) String startDate,@RequestParam(value = "endDate",required = false) String endDate) throws Exception {
        log.info("[ SchedulerController :: executeIncrementalIssueWithDateRangeSequentialSchedules ] :: 이슈 기반별 증분 수집 요청");
        schedulerService.discoverByDateRange(INCREMENTAL_ISSUE_BULK_SAVE_WITH_DATE_RANGE,startDate,endDate);
    }

    @GetMapping(
            value = {"/pdservice/reqstatus/updateFromES"}
    )
    public void updateReqStatusFromElasticsearch() throws Exception {
        log.info("[ SchedulerController :: updateReqStatusFromElasticsearch ] :: FROM_검색엔진_이슈데이터_TO_요구사항_REQSTATUS_동기화");
        schedulerService.updateReqStatusFromElasticsearch(SYNC_REQ_STATUS_FROM_ES);
    }

    @GetMapping(
            value = {"/pdservice/reqstatus/recreateFailedReqIssue"}
    )
    public void retryFailedReqStatusCreationToElasticsearch() throws Exception {
        log.info("[ SchedulerController :: retryFailedReqStatusCreationToElasticsearch ] :: 각_제품서비스_별_생성실패한_ALM_요구사항_이슈_재생성");
        schedulerService.retryFailedReqStatusCreationToElasticsearch(RECREATE_FAILED_ISSUE);
    }


    @PutMapping(
            value = {"/cacheStatusMappingData"}
    )
    public String cacheStatusMappingData() throws Exception {
        log.info("[ SchedulerController :: setStatusMappingData ] :: 상태 매핑 데이터 Redis 캐싱");
        return schedulerService.cacheStatusMappingData();
    }
}