package com.arms.api.wiki.service;

import com.arms.api.util.filerepository.model.FileRepositoryEntity;
import com.arms.api.util.filerepository.service.FileRepository;
import com.arms.egovframework.javaservice.treeframework.TreeConstant;
import com.arms.egovframework.javaservice.treeframework.service.TreeServiceImpl;
import com.arms.egovframework.javaservice.treeframework.util.EgovFileUploadUtil;
import com.arms.egovframework.javaservice.treeframework.util.EgovFormBasedFileVo;
import com.arms.egovframework.javaservice.treeframework.util.PropertiesReader;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import java.util.ArrayList;
import java.util.List;

@Slf4j
@Service("WikiService")
@RequiredArgsConstructor
public class WikiServiceImpl extends TreeServiceImpl implements WikiService {

    private final FileRepository fileRepository;

    public List<FileRepositoryEntity> imageUpload(MultipartHttpServletRequest multiRequest) {
        try {
            PropertiesReader propertiesReader = new PropertiesReader("com/arms/egovframework/property/globals.properties");
            String uploadDir = propertiesReader.getProperty("Globals.fileStorePath");
            long maxFileSize = TreeConstant.MAX_UPLOAD_FILESIZE;

            List<EgovFormBasedFileVo> uploadFiles = EgovFileUploadUtil.uploadFiles(multiRequest, uploadDir, maxFileSize);
            List<FileRepositoryEntity> fileRepositoryEntities = new ArrayList<>();

            for (EgovFormBasedFileVo uploadFile : uploadFiles) {

                FileRepositoryEntity fileRepositoryEntity = FileRepositoryEntity.builder()
                        .fileName(uploadFile.getFileName())
                        .contentType(uploadFile.getContentType())
                        .serverSubPath(uploadFile.getServerSubPath())
                        .physicalName(uploadFile.getPhysicalName())
                        .size(uploadFile.getSize())
                        .name(uploadFile.getName())
                        .url(uploadFile.getUrl())
                        .thumbnailUrl(uploadFile.getThumbnailUrl())
                        .delete_url(uploadFile.getDelete_url())
                        .delete_type(uploadFile.getDelete_type())
                        .build();

                fileRepositoryEntity.setRef(TreeConstant.First_Node_CID);
                fileRepositoryEntity.setC_title("for Wiki");
                fileRepositoryEntity.setC_type(TreeConstant.Leaf_Node_TYPE);

                FileRepositoryEntity uploadedFile = fileRepository.addNode(fileRepositoryEntity);

                fileRepositoryEntity.setUrl("/auth-user/api/arms/fileRepository/downloadFileByNode/" + uploadedFile.getId());
                fileRepositoryEntity.setThumbnailUrl("/auth-user/api/arms/fileRepository/thumbnailUrlFileToNode/" + uploadedFile.getId());
                fileRepositoryEntity.setDelete_url("/auth-user/api/arms/pdServiceDetail/deleteFileNode.do/" + uploadedFile.getId());

                fileRepository.updateNode(fileRepositoryEntity);

                fileRepositoryEntities.add(fileRepositoryEntity);
            }

            return fileRepositoryEntities;
        } catch (Exception ex) {
            throw new IllegalArgumentException(ex);
        }
    }


}
