package com.arms.config;

import feign.Request;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.concurrent.TimeUnit;

@Configuration
@EnableFeignClients("com.arms.api.util.communicate")
public class OpenFeignConfig {

    @Bean
    public Request.Options requestOptions() {
        return new Request.Options(
                30, TimeUnit.SECONDS,
                60, TimeUnit.MINUTES,
                true
        );
    }
}
