DELIMITER $$
DROP TRIGGER IF EXISTS TG_INSERT_T_ARMS_ANNUAL_INCOME;
$$
CREATE TRIGGER TG_INSERT_T_ARMS_ANNUAL_INCOME
    BEFORE  INSERT ON T_ARMS_ANNUAL_INCOME
    FOR EACH ROW
BEGIN
    IF NEW.C_ID <> 1 AND NEW.C_ID <> 2 THEN
        INSERT INTO T_ARMS_ANNUAL_INCOME_LOG (C_ID, C_PARENTID, C_POSITION, C_LEFT, C_RIGHT, C_LEVEL, C_TITLE, C_TYPE, C_METHOD, C_STATE, C_DATE, C_NAME, C_KEY, C_ANNUAL_INCOME)
        VALUES (NEW.C_ID,NEW.C_PARENTID,NEW.C_POSITION,NEW.C_LEFT,NEW.C_RIGHT,NEW.C_LEVEL,NEW.C_TITLE,NEW.C_TYPE,'create','최초등록데이터',now(), NEW.C_NAME, NEW.C_KEY, NEW.C_ANNUAL_INCOME);
    END IF;
END $$
DELIMITER ;

DELIMITER $$
DROP TRIGGER IF EXISTS TG_UPDATE_T_ARMS_ANNUAL_INCOME;
$$
CREATE TRIGGER TG_UPDATE_T_ARMS_ANNUAL_INCOME
    BEFORE  UPDATE ON T_ARMS_ANNUAL_INCOME
    FOR EACH ROW
BEGIN
    IF NEW.C_ID <> 1 AND NEW.C_ID <> 2 THEN
        INSERT INTO T_ARMS_ANNUAL_INCOME_LOG (C_ID, C_PARENTID, C_POSITION, C_LEFT, C_RIGHT, C_LEVEL, C_TITLE, C_TYPE, C_METHOD, C_STATE, C_DATE, C_NAME, C_KEY, C_ANNUAL_INCOME)
        VALUES (OLD.C_ID,OLD.C_PARENTID,OLD.C_POSITION,OLD.C_LEFT,OLD.C_RIGHT,OLD.C_LEVEL,OLD.C_TITLE,OLD.C_TYPE,'update','변경이전데이터',now(), OLD.C_NAME, OLD.C_KEY, OLD.C_ANNUAL_INCOME);
    INSERT INTO T_ARMS_ANNUAL_INCOME_LOG (C_ID, C_PARENTID, C_POSITION, C_LEFT, C_RIGHT, C_LEVEL, C_TITLE, C_TYPE, C_METHOD, C_STATE, C_DATE, C_NAME, C_KEY, C_ANNUAL_INCOME)
    VALUES (NEW.C_ID,NEW.C_PARENTID,NEW.C_POSITION,NEW.C_LEFT,NEW.C_RIGHT,NEW.C_LEVEL,NEW.C_TITLE,NEW.C_TYPE,'update','변경이후데이터',now(), NEW.C_NAME, NEW.C_KEY, NEW.C_ANNUAL_INCOME);
END IF;
END $$
DELIMITER ;

DELIMITER $$
DROP TRIGGER IF EXISTS TG_DELETE_T_ARMS_ANNUAL_INCOME;
$$
CREATE TRIGGER TG_DELETE_T_ARMS_ANNUAL_INCOME
    BEFORE  DELETE ON T_ARMS_ANNUAL_INCOME
    FOR EACH ROW
BEGIN
    IF OLD.C_ID <> 1 AND OLD.C_ID <> 2 THEN
        INSERT INTO T_ARMS_ANNUAL_INCOME_LOG (C_ID, C_PARENTID, C_POSITION, C_LEFT, C_RIGHT, C_LEVEL, C_TITLE, C_TYPE, C_METHOD, C_STATE, C_DATE, C_NAME, C_KEY, C_ANNUAL_INCOME)
        VALUES (OLD.C_ID,OLD.C_PARENTID,OLD.C_POSITION,OLD.C_LEFT,OLD.C_RIGHT,OLD.C_LEVEL,OLD.C_TITLE,OLD.C_TYPE,'delete','삭제된데이터',now(), OLD.C_NAME, OLD.C_KEY, OLD.C_ANNUAL_INCOME);
END IF;
END $$
DELIMITER ;