package com.arms.api.issue.resolution.strategy;

import com.arms.api.issue.resolution.model.IssueResolutionData;
import com.arms.api.serverinfo.model.ServerInfo;
import com.arms.api.serverinfo.service.ServerInfoService;
import com.arms.api.util.alm.JiraApi;
import com.arms.api.util.alm.JiraUtil;
import com.arms.api.util.errors.ErrorLogUtil;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.stereotype.Component;
import org.springframework.web.reactive.function.client.WebClient;

import java.util.List;

@Slf4j
@Component
@AllArgsConstructor
public class CloudJiraIssueResolutionStrategy implements IssueResolutionStrategy {

    private final JiraUtil jiraUtil;

    private final JiraApi jiraApi;

    private final ServerInfoService serverInfoService;

    @Override
    public List<IssueResolutionData> getIssueResolutionList(ServerInfo serverInfo) {

        try {
            WebClient webClient = jiraUtil.createJiraCloudCommunicator(serverInfo.getUri(), serverInfo.getUserId(),
                                                            serverInfoService.getDecryptPasswordOrToken(serverInfo));
            String resolutionEndpoint = jiraApi.getEndpoint().getIssue().getResolution();
            List<IssueResolutionData> 반환할_IssueResolutionData_목록 = jiraUtil.get(webClient, resolutionEndpoint,
                                                    new ParameterizedTypeReference<List<IssueResolutionData>>() {}).block();

            return 반환할_IssueResolutionData_목록;
        }
        catch (Exception e) {
            String 에러로그 = ErrorLogUtil.exceptionLoggingAndReturn(e, this.getClass().getName(),
                    "클라우드 지라("+ serverInfo.getConnectId() +") :: 이슈해결책_목록_가져오기");
            throw new IllegalArgumentException(에러로그);
        }
    }

}
