package com.arms.api.util.msa_communicate;

import com.arms.api.issue.almapi.model.entity.AlmIssueEntity;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@FeignClient(name = "backendCoreClient", url = "${arms.backend-core.url}")
public interface BackendCoreClient {

    @PostMapping("/arms/alarm/send-message")
    void sendMessage(@RequestParam("message") String message);

    @PostMapping("/arms/reqStatusSync/es-to-db")
    void transferAlmDataToBackend(@RequestBody List<AlmIssueEntity> almIssues);

}
