package com.arms.api.issue.status.dto;

import com.fasterxml.jackson.annotation.JsonInclude;
import lombok.*;

@Getter
@Setter
@Builder
@ToString
@NoArgsConstructor
@AllArgsConstructor
@JsonInclude(JsonInclude.Include.NON_NULL)
public class IssueStatusDTO {

    private String self;

    private String id;

    private String name;

    private String description;

    private String issueTypeId;

    private IssueStatusCategoryDTO statusCategory;

    public IssueStatusDTO(String self, String id, String name) {
        this.self = self;
        this.id = id;
        this.name = name;
    }

    @Override
    public int hashCode() {
        return Long.hashCode(Long.parseLong(id));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (obj == null || getClass() != obj.getClass()) return false;
        IssueStatusDTO that = (IssueStatusDTO) obj;
        return self.equals(that.self);
    }
}
