package com.arms.api.backoffice.information.timeoff.modal.vo;

import lombok.*;

import java.util.Objects;

@Getter
@Setter
@Builder
@ToString
@NoArgsConstructor
@AllArgsConstructor
public class UsersInfoVO {
    private String accountId;
    private String emailAddress;
    private String displayName;
    private String serverType;

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        UsersInfoVO that = (UsersInfoVO) o;
        return Objects.equals(emailAddress, that.emailAddress) &&
                Objects.equals(serverType, that.serverType);
    }

    @Override
    public int hashCode() {
        return Objects.hash(emailAddress, serverType);
    }
}
