package com.arms.api.holidayadmin.controller;

import com.arms.api.holidayadmin.model.dto.HolidayDTO;
import com.arms.api.holidayadmin.model.vo.HolidayVO;
import com.arms.api.holidayadmin.service.HolidayService;
import com.arms.api.util.response.CommonResponse;
import feign.Param;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("/holiday")
@Slf4j
@AllArgsConstructor
public class HolidayController {

    private final HolidayService bbsService;

    @GetMapping("/board-list/only-post-list")
    public ResponseEntity<CommonResponse.ApiResult<HolidayVO>> postList(@Param("baseDTO") HolidayDTO holidayDTO) {
        log.info("BbsController :: postList");
        return ResponseEntity.ok(CommonResponse.success(bbsService.bbsList(holidayDTO)));
    }

    @GetMapping("/board-list")
    public ResponseEntity<CommonResponse.ApiResult<HolidayVO>> boardList(@Param("baseDTO") HolidayDTO holidayDTO) {
        log.info("BbsController :: boardList");
        return ResponseEntity.ok(CommonResponse.success(bbsService.bbsList(holidayDTO)));
    }

    @PostMapping("/post-message")
    public ResponseEntity<CommonResponse.ApiResult<String>> savePostMessage(@RequestBody HolidayDTO holidayDTO) {
        log.info("BbsController :: savePostMessage");
        return ResponseEntity.ok(CommonResponse.success(bbsService.postMessage(holidayDTO)));
    }


    @PutMapping("/update-id/{updateId}")
    public ResponseEntity<CommonResponse.ApiResult<String>> update(
            @PathVariable(name = "updateId") String updateId,
            @RequestBody HolidayDTO holidayDTO
        ) {
        log.info("BbsController :: update");
        holidayDTO.setId(updateId);
        return ResponseEntity.ok(CommonResponse.success(bbsService.updateBbsAndGetId(holidayDTO)));
    }


    @DeleteMapping("/delete-id/{deleteId}")
    public ResponseEntity<CommonResponse.ApiResult<String>> deleteById(
        @PathVariable(name = "deleteId") String deleteId
    ) {
        log.info("BbsController :: deleteById");
        return ResponseEntity.ok(CommonResponse.success(bbsService.deleteBbsAndGetId(deleteId)));
    }


}
