package com.arms.api.issue.almapi.model.dto;

import com.arms.api.issue.priority.model.IssuePriorityDTO;
import com.arms.api.issue.resolution.model.IssueResolutionData;
import com.arms.api.issue.status.dto.IssueStatusDTO;
import com.arms.api.issue.type.dto.IssueTypeDTO;
import com.arms.api.project.dto.ProjectDTO;
import com.fasterxml.jackson.annotation.JsonInclude;
import lombok.*;

import java.util.Date;
import java.util.List;

@Getter
@Setter
@Builder
@ToString
@NoArgsConstructor
@AllArgsConstructor
@JsonInclude(JsonInclude.Include.NON_NULL)
public class IssueCreationFieldsDTO {

    private ProjectDTO project;

    private IssueTypeDTO issuetype;

    private String summary;

    private String description;

    private UserData reporter;

    private UserData assignee;

    private List<String> labels;

    private IssuePriorityDTO priority;

    private IssueStatusDTO status;

    private IssueResolutionData resolution;

    private Date startDate;

    private Date dueDate;
}
