package com.arms.api.issue.almapi.model.vo;

import com.arms.api.issue.almapi.model.dto.AlmIssueWithRequirementDTO;
import lombok.Getter;
import lombok.extern.slf4j.Slf4j;

import java.util.List;
import java.util.Map;

import static java.util.stream.Collectors.*;


@Getter
@Slf4j
public class OnPremissRedmineVOCollection {

    private final List<OnPremissRedmineIssueVO> onPremissRedmineIssueVO;

    public OnPremissRedmineVOCollection(List<OnPremissRedmineIssueVO> onPremissRedmineIssueVO){
        this.onPremissRedmineIssueVO = onPremissRedmineIssueVO;
    }

    public List<OnPremissRedmineIssueVO> appliedLinkedIssuePdServiceVO() {

        Map<OnPremissRedmineIssueVO, List<AlmIssueWithRequirementDTO>> onPremissRedmineIssueVOListMap
            = onPremissRedmineIssueVO
                .stream()
                .collect(groupingBy(vo -> vo, mapping(OnPremissRedmineIssueVO::getAlmIssueWithRequirementDTO, toList())));

        return onPremissRedmineIssueVOListMap
                .entrySet()
                .stream().map(a-> a.getKey().appliedLinkedIssuePdServiceElement(a.getValue())).toList();

    }

}
