package com.arms.api.requirement.service;

import com.arms.api.analysis.time.dto.TimeAggrDTO;
import com.arms.api.issue.almapi.model.entity.AlmIssueEntity;
import com.arms.api.requirement.model.dto.RequirementAggrDTO;
import com.arms.api.requirement.model.dto.RequirementDTO;
import com.arms.api.requirement.model.dto.SubtaskAndLinkedIssuesRequestDTO;
import com.arms.api.requirement.model.vo.HierarchicalAlmIssue;
import com.arms.api.requirement.model.vo.ReqProgressVO;
import com.arms.api.requirement.model.vo.RequirementVO;
import com.arms.egovframework.javaservice.esframework.model.dto.esquery.SearchDocDTO;
import com.arms.egovframework.javaservice.esframework.esquery.SimpleQuery;

import java.util.List;

public interface RequirementService {

    List<RequirementVO> 제품_요구사항별_담당자_목록(RequirementAggrDTO requirementAggrDTO);

    List<AlmIssueEntity> 함께_생성된_요구사항_이슈목록(Long 제품서비스_아이디, List<Long> 버전_아이디, Long 요구사항_아이디);

    List<AlmIssueEntity> deletedIssueList(Long pdServiceLink,List<Long> pdServiceVersionLinks);

    int 이슈_삭제철회(List<AlmIssueEntity> 삭제_철회대상_목록) throws Exception;

    List<ReqProgressVO> 일반_버전필터_해결책유무_검색(RequirementDTO requirementDTO, String resolution);

    List<HierarchicalAlmIssue> issueListByAdvancedDiscovery(RequirementDTO requirementDTO);
    List<AlmIssueEntity> issueListByUpdatedDate(RequirementDTO requirementDTO);
    List<AlmIssueEntity> issueListByUpdated2ndTab(RequirementDTO requirementDTO);
    List<AlmIssueEntity> issueListByOverallUpdatedDate(RequirementDTO requirementDTO);

    List<HierarchicalAlmIssue> subtasksAndLinkedIssues(SubtaskAndLinkedIssuesRequestDTO subtaskAndLinkedIssuesRequestDTO);

    List<AlmIssueEntity> getAllListByRequirementDTO(RequirementDTO requirementDTO);
    List<AlmIssueEntity> getIssuesByRequirementDTO(SimpleQuery<SearchDocDTO> simpleQuery);
    List<AlmIssueEntity> getIssuesByRequirementDTO(SimpleQuery<SearchDocDTO> simpleQuery, String field, String startDate, String endDate);
    List<AlmIssueEntity> getRelationIssuesByRequirementDTO(TimeAggrDTO timeAggrDTO);
}
