package com.arms.api.serverinfo.model;

import com.arms.egovframework.javaservice.esframework.annotation.ElasticSearchCreatedDate;
import com.arms.egovframework.javaservice.esframework.annotation.ElasticSearchUpdateDate;
import com.arms.egovframework.javaservice.esframework.model.entity.BaseEntity;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonTypeName;
import lombok.*;
import org.springframework.data.annotation.Id;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;

import java.util.Date;

@Data
@Builder
@AllArgsConstructor
@Getter
@Setter
@Document(indexName = "#{@serverinfo}")
@JsonTypeName("com.arms.api.serverinfo.model.ServerInfoEntity")
@JsonIgnoreProperties(ignoreUnknown = true)
public class ServerInfoEntity implements BaseEntity {

    @Id
    @Field(type = FieldType.Keyword, name = "connectId")
    private String connectId;

    @Field(type = FieldType.Text, name = "type")
    private String type;

    @Field(type = FieldType.Text, name = "userId")
    private String userId;

    @Field(type = FieldType.Text, name = "passwordOrToken")
    private String passwordOrToken;

    @Field(type = FieldType.Text, name = "uri")
    private String uri;

    @Field(type = FieldType.Date, name = "created_date")
    @ElasticSearchCreatedDate
    @Setter
    private Date createdDate;

    @Field(type = FieldType.Date, name = "updated_date")
    @ElasticSearchUpdateDate
    @Setter
    private Date updatedDate;

    public ServerInfoEntity() {
    }
}
