package com.arms.api.serverinfo.msa_communicate;

import com.arms.api.issue.almapi.model.dto.ArmsStateCategoryDTO;
import com.arms.api.util.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(name = "middle-proxy", url = "${arms.middle-proxy.url}")
public interface MiddleProxyArmsStateCategory {

    @GetMapping("/mapping/category")
    CommonResponse.ApiResult<ArmsStateCategoryDTO> getArmsStateCategory(
            @RequestParam("serverId") String serverId,
            @RequestParam("projectKey") String projectKey,
            @RequestParam("issueTypeId") String issueTypeId,
            @RequestParam("issueStatusId") String issueStatusId);

}