package com.arms.api.keycloak.user.service;

import lombok.AllArgsConstructor;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.representations.idm.GroupRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

@Service
@AllArgsConstructor
public class KeycloakUserServiceImpl implements KeycloakUserService {

    private final RealmResource realmResource;

    private final String ADMIN = "ROLE_ADMIN";

    private Boolean checkRolePermission(String userId, String currentPage) {
        List<RoleRepresentation> roleRepresentations = realmResource.users().get(userId).roles().realmLevel().listEffective(false);

        for (RoleRepresentation roleRepresentation : roleRepresentations) {
            Map<String, List<String>> attributes = roleRepresentation.getAttributes();

            if (ADMIN.equals(roleRepresentation.getName())) {
                return true;
            }

            if (attributes != null && attributes.containsKey(currentPage)) {
                return true;
            }
        }

        return false;
    }

    private Boolean checkUserPermission(String userId, String currentPage) {
        UserRepresentation userRepresentation = realmResource.users().get(userId).toRepresentation();
        Map<String, List<String>> attributes = userRepresentation.getAttributes();

        if (attributes != null && attributes.containsKey(currentPage)) {
            return true;
        }

        return false;
    }

    private Boolean checkGroupPermission(String userId, String currentPage) {
        List<GroupRepresentation> groupRepresentations = realmResource.users().get(userId).groups();

        for (GroupRepresentation groupRepresentation : groupRepresentations) {
            GroupRepresentation group = realmResource.groups().group(groupRepresentation.getId()).toRepresentation();
            Map<String, List<String>> attributes = group.getAttributes();

            if (attributes != null && attributes.containsKey(currentPage)) {
                return true;
            }
        }

        return false;
    }

    public Boolean ckeckPermissions(String userId, String currentPage) {
        Boolean rolePermission = checkRolePermission(userId, currentPage);

        if (!rolePermission) {
            Boolean userPermission = checkUserPermission(userId, currentPage);

            if (!userPermission) {
               return checkGroupPermission(userId, currentPage);
            }

            return true;
        }

        return true;
    }
}
