(function () {
	CKEDITOR.plugins.add("linkeddoc", {
		requires: ["button", "dialog"],
		init: function (editor) {
			CKEDITOR.skin.addIcon("linkeddoc", this.path + "icon/linkeddoc.png");
			CKEDITOR.dialog.add("linkeddoc", this.path + "dialogs/linkeddoc.js");

			editor.filter.allow(
				"div(well,well-sm); div(doc-body); a(doc-link)[href,target]; p(text-muted,updated-date)",
				"linkeddoc"
			);

			editor.addCommand("open.linkeddoc.dialog", {
				context: "linkeddoc",
				exec: function () {
					editor.openDialog("linkeddoc");
				}
			});

			editor.widgets.add("linkeddoc", {
				allowedContent:
					"div(!well,!well-sm); div(!doc-body); a(!doc-link)[!href,!target]; p(!text-muted,!updated-date)",

				requiredContent: "div(well)",

				template:
					"<div class='well well-sm'>" +
					"<h4>" +
					"<a class='doc-link' href='#' target='_blank'></a>" +
					"</h4>" +
					"<div class='doc-body'></div>" +
					"<p class='text-muted updated-date'></p>" +
					"</div>",

				data: function () {
					var link = this.element.findOne(".doc-link");
					var updatedDate = this.element.findOne(".updated-date");
					var content = this.element.findOne(".doc-body");

					link.setText(this.data.title);
					link.setAttribute("href", this.data.url || "#");
					updatedDate.setText("Updated  " + this.data.updatedDate);
					content.setText(this.data.desc);
				}
			});

			editor.ui.addButton("linkeddoc", {
				label: "Linked Doc",
				command: "open.linkeddoc.dialog",
				toolbar: "basicstyles,1"
			});
		}
	});

	CKEDITOR.LINKEDDOC = "linkeddoc";
})();
